/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.exports.fixup;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.exports.fixup.AnnotationFixupStrategy;
import com.ibm.cognos.internal.hts.deployment.exports.fixup.CMTaskUserFixupStrategy;
import com.ibm.cognos.internal.hts.deployment.exports.fixup.FixupStrategy;
import com.ibm.cognos.internal.hts.deployment.exports.fixup.TaskMessageFixupStrategy;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FixupStrategyFactory {
    private Map<Class<?>, Class<? extends FixupStrategy>> strategyMap = new HashMap();
    private FixupStrategy defaultStrategy;

    public FixupStrategyFactory() {
        this.strategyMap.put(HTSMessage.class, TaskMessageFixupStrategy.class);
        this.strategyMap.put(Annotation.class, AnnotationFixupStrategy.class);
        this.strategyMap.put(HTSTaskUser.class, CMTaskUserFixupStrategy.class);
        this.defaultStrategy = new FixupStrategy(){

            @Override
            public void setObject(Object pojo) {
            }

            @Override
            public void writeFixup(DeploymentResources resources, Writer writer) {
            }

            @Override
            public void collectFixupData(Set<String> collector) {
            }

            @Override
            public void setFixupCache(Map<String, BaseClass> cache) {
            }
        };
    }

    public FixupStrategy getFixupStrategy(Object pojo) throws HumanTaskServiceException {
        FixupStrategy strategy = null;
        try {
            Class<? extends FixupStrategy> strategyClazz = this.strategyMap.get(pojo.getClass());
            if (strategyClazz == null) {
                for (Class<?> keySetClass : this.strategyMap.keySet()) {
                    Class<?> pojoClass = pojo.getClass();
                    if (pojoClass.isAssignableFrom(keySetClass)) {
                        strategyClazz = this.strategyMap.get(keySetClass);
                        break;
                    }
                    if (!keySetClass.isAssignableFrom(pojoClass)) continue;
                    strategyClazz = this.strategyMap.get(keySetClass);
                    break;
                }
            }
            if (strategyClazz != null) {
                strategy = strategyClazz.newInstance();
                strategy.setObject(pojo);
            } else {
                strategy = this.defaultStrategy;
            }
        }
        catch (Exception e) {
            Utils.logException(e);
            Utils.throwHumanTaskServiceException(e);
        }
        return strategy;
    }

    public void setFixupStrategy(Class<?> clazz, Class<? extends FixupStrategy> strategyClass) {
        this.strategyMap.put(clazz, strategyClass);
    }
}

