/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.exports.fixup;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.AxisUtils;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.IOException;
import java.io.Writer;
import org.apache.axis.client.Stub;

public class FixupStrategyImpl {
    public void startFixups(Writer writer) throws HumanTaskServiceException {
        try {
            writer.write("<cmReferences>");
        }
        catch (IOException e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getMessage()});
        }
    }

    public void endFixups(Writer writer) throws HumanTaskServiceException {
        try {
            writer.write("</cmReferences>");
        }
        catch (IOException e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getMessage()});
        }
    }

    public void writeFixup(DeploymentResources resources, Writer writer, String id, String path) throws HumanTaskServiceException {
        try {
            writer.write("<cmReference>");
            writer.write("<id>" + id + "</id>");
            writer.write("<searchPath>" + path + "</searchPath>");
            writer.write("</cmReference>");
        }
        catch (IOException e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSearchpath(DeploymentResources resources, String id) throws HumanTaskServiceException {
        ContentManagerServiceClientPort cmPort = null;
        String searchpath = null;
        try {
            JobBiBusHeaders headers = resources.getLoggedInHeader();
            cmPort = Client.instance().getContentManagerServiceClient(headers);
            AxisUtils.setHeader((Stub)cmPort.getBinding(), (BiBusHeader)headers.getBiBusHeader());
            QueryRequest request = new QueryRequest();
            request.setSearch(ObjectModelUtil.getSearchPathFromGuid((String)id).get_value());
            request.setProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.storeID});
            BaseClass reply = cmPort.query(request);
            searchpath = reply == null ? null : reply.getSearchPath().getValue();
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getMessage()});
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return searchpath;
    }
}

