/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.exports.fixup;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.AxisUtils;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.exports.fixup.FixupStrategy;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRendering;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.client.Stub;
import org.apache.tools.ant.filters.StringInputStream;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

class TaskMessageFixupStrategy
implements FixupStrategy {
    private QName deploymentRenderingType = new QName("deploymentExportXslt");
    private HTSMessage message;
    private static HashMap<String, Templates> m_templateMap = new HashMap();
    private Map<String, BaseClass> fixupCache;

    TaskMessageFixupStrategy() {
    }

    @Override
    public void setObject(Object pojo) {
        this.message = (HTSMessage)pojo;
    }

    @Override
    public void writeFixup(DeploymentResources resources, Writer writer) throws HumanTaskServiceException {
        HTSTaskclass taskClass = this.message.getTask().getHtsTaskclass();
        try {
            String cmStoreIds = this.transformInputMessage(taskClass, this.message.getMessage());
            if (cmStoreIds != null && !"".equals(cmStoreIds)) {
                SAXReader reader = new SAXReader();
                Element cmStoreIdsEl = reader.read((Reader)new StringReader(cmStoreIds)).getRootElement();
                this.retrieveCmSearchPaths(resources, cmStoreIdsEl);
                writer.write(cmStoreIdsEl.asXML());
            }
        }
        catch (DocumentException cmStoreIds) {
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_EXPORT_DEPLOYMENT_FIXUP_FAILED, new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveCmSearchPaths(DeploymentResources resources, Element cmStoreIdsEl) throws HumanTaskServiceException {
        ContentManagerServiceClientPort cmPort = null;
        try {
            List cmReferenceNodes = cmStoreIdsEl.selectNodes(cmStoreIdsEl.getUniquePath() + "/cmReference");
            ArrayList<QueryRequest> requests = new ArrayList<QueryRequest>();
            boolean hasIds = false;
            ArrayList<Node> duffs = new ArrayList<Node>();
            for (Node cmReferenceNode : cmReferenceNodes) {
                hasIds = true;
                Element elm = (Element)cmReferenceNode;
                String id = elm.element("id").getText();
                if (id == null || id.equals("")) {
                    duffs.add(cmReferenceNode);
                    continue;
                }
                if (this.fixupCache != null) continue;
                QueryRequest request = new QueryRequest();
                request.setSearch(ObjectModelUtil.getSearchPathFromGuid((String)id).get_value());
                request.setProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.storeID});
                requests.add(request);
            }
            cmReferenceNodes.removeAll(duffs);
            if (hasIds) {
                if (this.fixupCache == null) {
                    JobBiBusHeaders headers = resources.getLoggedInHeader();
                    cmPort = Client.instance().getContentManagerServiceClient(headers);
                    AxisUtils.setHeader((Stub)cmPort.getBinding(), (BiBusHeader)headers.getBiBusHeader());
                    QueryReply[] replies = cmPort.queryMultiple(requests.toArray(new QueryRequest[0]));
                    Map<String, BaseClass> tempCache = this.buildTemporaryCache(replies);
                    this.populateSearchPaths(tempCache, cmReferenceNodes);
                } else {
                    this.populateSearchPaths(this.fixupCache, cmReferenceNodes);
                }
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_EXPORT_DEPLOYMENT_FIXUP_FAILED);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
    }

    private Map<String, BaseClass> buildTemporaryCache(QueryReply[] replies) {
        HashMap<String, BaseClass> tempCache = new HashMap<String, BaseClass>();
        if (replies != null) {
            for (int i = 0; i < replies.length; ++i) {
                BaseClass[] baseClasses;
                QueryReply reply = replies[i];
                if (reply == null || (baseClasses = reply.getQueryResult()) == null || baseClasses.length <= 0) continue;
                for (int j = 0; j < baseClasses.length; ++j) {
                    BaseClass baseClass = baseClasses[j];
                    if (baseClass == null) continue;
                    String key = baseClass.getStoreID().getValue().get_value();
                    tempCache.put(key, baseClass);
                }
            }
        }
        return tempCache;
    }

    private void populateSearchPaths(Map<String, BaseClass> cmCache, List<Node> cmReferenceNodes) {
        for (Element element : cmReferenceNodes) {
            String id = element.element("id").getText();
            BaseClass base = cmCache.get(id);
            if (base == null) continue;
            Element searchPathNode = element.element("searchPath");
            String searchpath = base.getSearchPath().getValue();
            searchPathNode.setText(searchpath);
        }
    }

    private String transformInputMessage(HTSTaskclass taskClass, String inputMessage) throws HumanTaskServiceException {
        String transformedMessage = null;
        try {
            Transformer transformer = this.getTransformer(taskClass);
            if (transformer != null) {
                StringReader reader = new StringReader(inputMessage);
                StringWriter writer = new StringWriter();
                transformer.transform(new StreamSource(reader), new StreamResult(writer));
                transformedMessage = writer.getBuffer().toString();
            }
        }
        catch (Throwable t) {
            Utils.throwHumanTaskServiceException(t, UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{t.getMessage()});
        }
        return transformedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer getTransformer(HTSTaskclass taskClass) throws TransformerConfigurationException {
        Templates template;
        Transformer transformer = null;
        if (!m_templateMap.containsKey(taskClass.getId())) {
            List<HTSRendering> renderings = taskClass.getHtsRenderings();
            HTSRendering deploymentRendering = null;
            Iterator<HTSRendering> it = renderings.iterator();
            while (it.hasNext() && deploymentRendering == null) {
                HTSRendering rendering = it.next();
                if (!rendering.getType().equals(this.deploymentRenderingType.toString())) continue;
                deploymentRendering = rendering;
            }
            if (deploymentRendering != null && deploymentRendering.getRenderValue() != null && !"".equals(deploymentRendering.getRenderValue())) {
                HashMap<String, Templates> hashMap = m_templateMap;
                synchronized (hashMap) {
                    if (!m_templateMap.containsKey(taskClass.getId())) {
                        TransformerFactory tFactory = TransformerFactory.newInstance();
                        StringInputStream deployRenderingValueStream = new StringInputStream(deploymentRendering.getRenderValue());
                        Templates template2 = tFactory.newTemplates(new StreamSource((InputStream)deployRenderingValueStream));
                        m_templateMap.put(taskClass.getId(), template2);
                    }
                }
            }
        }
        if ((template = m_templateMap.get(taskClass.getId())) != null) {
            transformer = template.newTransformer();
        }
        return transformer;
    }

    @Override
    public void collectFixupData(Set<String> collector) throws HumanTaskServiceException {
        HTSTaskclass taskClass = this.message.getTask().getHtsTaskclass();
        try {
            String cmStoreIds = this.transformInputMessage(taskClass, this.message.getMessage());
            if (cmStoreIds != null && !"".equals(cmStoreIds)) {
                SAXReader reader = new SAXReader();
                Element cmStoreIdsEl = reader.read((Reader)new StringReader(cmStoreIds)).getRootElement();
                this.collectFixupIds(collector, cmStoreIdsEl);
            }
        }
        catch (DocumentException cmStoreIds) {
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_EXPORT_DEPLOYMENT_FIXUP_FAILED, new Object[]{e.getMessage()});
        }
    }

    void collectFixupIds(Set<String> collector, Element cmStoreIdsEl) {
        List cmReferenceNodes = cmStoreIdsEl.selectNodes(cmStoreIdsEl.getUniquePath() + "/cmReference");
        for (Node cmReferenceNode : cmReferenceNodes) {
            Element elm = (Element)cmReferenceNode;
            String id = elm.element("id").getText();
            if (id == null || "".equals(id)) continue;
            collector.add(id);
        }
    }

    @Override
    public void setFixupCache(Map<String, BaseClass> cache) {
        this.fixupCache = cache;
    }
}

