/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.id;

import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.MetaDataUtils;
import com.ibm.cognos.internal.hts.deployment.id.DefaultIdStrategy;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PrePersist;
import org.apache.openjpa.jdbc.meta.ClassMapping;

public class AnnotationIdStrategy
extends DefaultIdStrategy {
    private DeploymentResources resources;
    private Map<Class<?>, Map<String, String>> classMap = new HashMap();
    private Long lastObjectId;

    public AnnotationIdStrategy(DeploymentResources resources) {
        this.resources = resources;
    }

    @Override
    public void prePersist(Object object, ClassMapping mapping) throws HumanTaskServiceException {
        try {
            this.prePersist(object);
            this.lastObjectId = (Long)MetaDataUtils.setPrimaryKey(object, mapping, new Long(0L));
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
    }

    @Override
    public void postPersist(Object object, ClassMapping mapping) throws HumanTaskServiceException {
        try {
            String newObjectId = String.valueOf(MetaDataUtils.getPrimaryKey(object, mapping));
            this.getIdMap(this.classMap, mapping).put(String.valueOf(this.lastObjectId), newObjectId);
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
    }

    private void prePersist(Object object) throws HumanTaskServiceException {
        Method[] methods = MetaDataUtils.getMethodsWithAnnotation(PrePersist.class, object);
        try {
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].getParameterTypes().length != 0) continue;
                methods[i].invoke(object, new Object[0]);
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_DEPLOYMENT_FAILED);
        }
    }

    @Override
    public Object getNewId(Object oldId, ClassMapping mapping) {
        String id = this.getIdMap(this.persistedEquivalents, mapping).get(oldId);
        if (id == null) {
            id = this.getIdMap(this.classMap, mapping).get(oldId);
        }
        return id;
    }

    @Override
    public boolean doExistingCheck() {
        return false;
    }
}

