/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports;

import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.imports.PojoImportDelegate;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportDelegate
extends DefaultHandler {
    static final String POJO = "pojo";
    static final String LINK = "link";
    static final String CMREF = "cmReferences";
    private ImportDelegate parent;
    private ImportDelegate delegate;
    private DeploymentResources resources;
    private boolean importOverwrite;

    protected ImportDelegate(boolean importOverwrite, DeploymentResources resources) {
        this.importOverwrite = importOverwrite;
        this.resources = resources;
    }

    protected ImportDelegate(ImportDelegate parent, boolean importOverwrite, DeploymentResources resources) {
        this(importOverwrite, resources);
        this.parent = parent;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals(POJO)) {
            this.setDelegate(new PojoImportDelegate(this, this.importOverwrite, this.resources));
        }
        if (this.hasDelegate()) {
            this.getDelegate().startElement(uri, localName, name, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.hasDelegate()) {
            this.getDelegate().endElement(uri, localName, name);
        }
        if (name.equals(POJO)) {
            this.setDelegate(null);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.hasDelegate()) {
            this.getDelegate().characters(ch, start, length);
        }
    }

    protected ImportDelegate getParent() {
        return this.parent;
    }

    protected boolean hasDelegate() {
        return this.delegate != null;
    }

    protected ImportDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(ImportDelegate delegate) {
        this.delegate = delegate;
    }

    protected DeploymentResources getResources() {
        return this.resources;
    }

    protected boolean isImportOverwrite() {
        return this.importOverwrite;
    }
}

