/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.ibm.cognos.internal.hts.deployment.DeploymentFileStream;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.imports.ImportDelegate;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.schema.SchemaVersionUpdate;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ImportReader {
    private Reader reader;
    private DefaultHandler handler;
    private DeploymentResources resources;
    private int version;

    public ImportReader(DeploymentFileStream fileStream, DeploymentResources resources, boolean importOverwrite) throws IOException, CAMCryptoException, HumanTaskServiceException {
        this.reader = fileStream.getDeploymentFileReader();
        this.version = fileStream.getDeploymenteVersion();
        this.handler = new ImportDelegate(importOverwrite, resources);
        this.resources = resources;
    }

    public void read() throws HumanTaskServiceException {
        try {
            XMLFilter filter;
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            InputSource input_source = new InputSource(this.reader);
            SchemaVersionUpdate updater = this.resources.getSchemaChangefactory().getSchemaVersionUpdate(this.version);
            if (updater != null && (filter = updater.getDeploymentFilterChain()) != null) {
                filter.setParent(xmlReader);
                xmlReader = filter;
            }
            this.resources.getPersistenceUtil().getTransaction().begin();
            xmlReader.setContentHandler(this.handler);
            xmlReader.parse(input_source);
            this.resources.getPersistenceUtil().getTransaction().commit();
        }
        catch (Throwable e) {
            Utils.logException(e);
            if (this.resources.getPersistenceUtil().getTransaction().isActive()) {
                this.resources.getPersistenceUtil().getTransaction().rollback();
            }
            throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getLocalizedMessage()}, e);
        }
    }
}

