/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports;

import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.imports.ImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.LinkInsert;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LinkImportDelegate
extends ImportDelegate {
    private static final String LINK = "link";
    private static final String OWNER = "ownerPojo";
    private static final String CHILD = "childPojo";
    private static final String NAME = "name";
    private static final String ACCESSOR = "accessorProperty";
    private StringBuffer ownerId = new StringBuffer();
    private StringBuffer childId = new StringBuffer();
    private LinkInsert linkInsert = new LinkInsert(this.getResources(), this.isImportOverwrite());
    private String currentProperty;

    public LinkImportDelegate(ImportDelegate parent, boolean importOverwrite, DeploymentResources resources) {
        super(parent, importOverwrite, resources);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (OWNER.equals(this.currentProperty)) {
            this.ownerId.append(new String(ch, start, length));
        } else if (CHILD.equals(this.currentProperty)) {
            this.childId.append(new String(ch, start, length));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (CHILD.equals(this.currentProperty)) {
            this.linkInsert.addSlaveId(this.childId.toString());
            this.childId.setLength(0);
        } else if (OWNER.equals(this.currentProperty)) {
            this.linkInsert.setOwnerId(this.ownerId.toString());
        }
        this.currentProperty = null;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (OWNER.equals(name)) {
            String ownerName = attributes.getValue(NAME);
            this.linkInsert.setOwnerMapping(this.getResources().getMetaDataSchemaTranslator().getClassMappingByPojoName(ownerName));
            String accessor = attributes.getValue(ACCESSOR);
            FieldMapping accesorField = this.linkInsert.getOwnerClass().getFieldMapping(accessor);
            this.linkInsert.setAccessorfield(accesorField);
        } else if (CHILD.equals(name)) {
            String childName = attributes.getValue(NAME);
            this.linkInsert.setChildMapping(this.getResources().getMetaDataSchemaTranslator().getClassMappingByPojoName(childName));
        }
        this.currentProperty = name;
    }

    public LinkInsert getLinkInsert() {
        return this.linkInsert;
    }

    public void setLinkInsert(LinkInsert linkInsert) {
        this.linkInsert = linkInsert;
    }
}

