/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports;

import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.MetaDataUtils;
import com.ibm.cognos.internal.hts.deployment.imports.conflicts.ImportConflictResolver;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.meta.FieldMetaData;

public final class LinkInsert {
    private boolean importOverwrite;
    private String ownerId = "";
    private ClassMapping ownerMapping;
    private ClassMapping childMapping;
    private FieldMapping accessorfield;
    private Stack<String> childIds = new Stack();
    private DeploymentResources resources;
    private static boolean verbose = true;

    public LinkInsert(DeploymentResources resources, boolean importOverwrite) {
        this.importOverwrite = importOverwrite;
        this.resources = resources;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public ClassMapping getOwnerClass() {
        return this.ownerMapping;
    }

    public void setOwnerMapping(ClassMapping ownerClass) {
        this.ownerMapping = ownerClass;
    }

    public ClassMapping getChildMapping() {
        return this.childMapping;
    }

    public void setChildMapping(ClassMapping childclass) {
        this.childMapping = childclass;
    }

    public Stack<String> getSlaveIds() {
        return this.childIds;
    }

    public void setImportOverwrite(boolean importOverwrite) {
        this.importOverwrite = importOverwrite;
    }

    public void addSlaveId(String childId) {
        childId = String.valueOf(this.resources.getIdStrategy().getNewId(childId, this.childMapping));
        this.childIds.push(childId);
    }

    public void removeObject(Object owner) throws HumanTaskServiceException {
        if (this.childMapping == null) {
            return;
        }
        Class childClass = this.childMapping.getDescribedType();
        try {
            for (Object e : this.childIds) {
                if (verbose) {
                    Utils.debug("removing child " + this.ownerMapping.getDescribedType() + " : " + this.ownerId + " -> " + childClass + " : " + e);
                }
                if (this.resources.getIdStrategy().isPersistedEquivalentValue(e, this.getChildMapping())) continue;
                Object thing = this.resources.getPersistenceUtil().loadById(childClass, e.toString());
                this.resources.getPersistenceUtil().deleteById(childClass, e.toString());
                this.resources.getIdStrategy().addSkippedId(e, this.childMapping);
                ImportConflictResolver resolver = null;
                resolver = this.resources.getConflictResolverFactory().getImportConflictResolver(this.childMapping, this.resources);
                if (resolver == null) continue;
                resolver.skippedObject(this.childMapping, thing);
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
    }

    public void updateObject(Object owner) throws HumanTaskServiceException {
        if (this.childMapping == null) {
            return;
        }
        Class ownerClass = this.ownerMapping.getDescribedType();
        Class childClass = this.childMapping.getDescribedType();
        try {
            ArrayList<Object> childs;
            if (!ownerClass.equals(owner.getClass())) {
                Utils.throwHumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{this.ownerId});
            }
            if ((childs = (ArrayList<Object>)MetaDataUtils.getPropertyValue((FieldMetaData)this.accessorfield, owner)) == null) {
                childs = new ArrayList<Object>();
            }
            for (String childId : this.childIds) {
                Object child = this.resources.getPersistenceUtil().loadById(childClass, childId);
                if (child == null) {
                    throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_FAILED);
                }
                childs.add(child);
                if (!verbose) continue;
                Object ownerId = MetaDataUtils.getPrimaryKey(owner, this.getOwnerClass());
                Utils.debug("adding child " + ownerClass + " : " + ownerId + " -> " + childClass + " : " + childId);
            }
            MetaDataUtils.setPropertyValue((FieldMetaData)this.accessorfield, owner, childs);
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{e.getMessage()});
        }
    }

    private boolean isImportOverwrite() {
        return this.importOverwrite;
    }

    public FieldMapping getAccessorfield() {
        return this.accessorfield;
    }

    public void setAccessorfield(FieldMapping accessorfield) {
        this.accessorfield = accessorfield;
    }
}

