/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports;

import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.imports.ImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.LinkImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.LinkInsert;
import com.ibm.cognos.internal.hts.deployment.imports.TableInsert;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.FixupImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.FixupImportDelegateFactory;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PojoImportDelegate
extends ImportDelegate {
    private static final String PROPERTY = "property";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String FK = "fk";
    private static final String NIL = "nil";
    private static final String XSINAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private TableInsert insert;
    private List<LinkInsert> linkInsert = new ArrayList<LinkInsert>();

    public PojoImportDelegate(ImportDelegate parent, boolean importOverwrite, DeploymentResources resources) {
        super(parent, importOverwrite, resources);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.hasDelegate()) {
            this.getDelegate().characters(ch, start, length);
        } else if (this.insert != null && this.insert.getCurentPropertyName() != null) {
            this.addPropertyValueToPojoInsert(new String(ch, start, length));
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        try {
            if (this.hasDelegate()) {
                this.getDelegate().startElement(uri, localName, name, attributes);
            } else if (name.equals("pojo")) {
                this.setPojoInsert(attributes);
            } else if (name.equals(PROPERTY)) {
                this.addPropertyToPojoInsert(attributes);
            } else if (name.equals("link")) {
                this.setDelegate(new LinkImportDelegate(this, false, this.getResources()));
            } else if (name.equals("cmReferences")) {
                FixupImportDelegateFactory factory = this.getResources().getFixupImportDelegateFactory();
                FixupImportDelegate delegate = factory.getFixupImportDelegate(this.insert, this, this.isImportOverwrite(), this.getResources());
                this.setDelegate(delegate);
                this.getDelegate().startElement(uri, localName, name, attributes);
            }
        }
        catch (HumanTaskServiceException e) {
            Utils.logException((Throwable)((Object)e), UsI18NCode.MSG_USV_IMPORT_DEPLOYMENT_FIXUP_FAILED, new Object[]{e.getMessage()});
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            if (this.hasDelegate()) {
                this.getDelegate().endElement(uri, localName, name);
            } else if (name.equals("pojo")) {
                this.insert.writeTable(this.linkInsert);
                this.insert = null;
                this.getParent().setDelegate(null);
            } else if (name.equals(PROPERTY) && this.insert != null) {
                this.insert.setCurentPropertyName(null);
            }
            if (name.equals("link")) {
                LinkImportDelegate linkDelegate = (LinkImportDelegate)this.getDelegate();
                if (linkDelegate != null) {
                    this.linkInsert.add(linkDelegate.getLinkInsert());
                }
                this.setDelegate(null);
            }
        }
        catch (HumanTaskServiceException e) {
            Utils.logException((Throwable)((Object)e));
            throw new SAXException((Exception)((Object)e));
        }
    }

    public TableInsert getPendingInsert() {
        return this.insert;
    }

    private void addPropertyValueToPojoInsert(String data) {
        this.insert.appendPropertyValue(data);
    }

    private void addPropertyToPojoInsert(Attributes attributes) {
        String propertyName = attributes.getValue(NAME);
        String propertyType = attributes.getValue(TYPE);
        String foreignKey = attributes.getValue(FK);
        String nil = attributes.getValue(XSINAMESPACE, NIL);
        this.insert.addProperty(propertyName, propertyType, foreignKey);
        boolean nullValue = false;
        if (nil != null) {
            nullValue = Boolean.parseBoolean(nil);
        }
        if (!nullValue) {
            this.insert.appendPropertyValue("");
        }
    }

    private TableInsert setPojoInsert(Attributes attributes) {
        String pojoName = attributes.getValue(NAME);
        ClassMapping mapping = this.getResources().getMetaDataSchemaTranslator().getClassMappingByPojoName(pojoName);
        this.insert = new TableInsert(this.getResources(), mapping, this.isImportOverwrite());
        return this.insert;
    }

    public List<LinkInsert> getLinkInsert() {
        return this.linkInsert;
    }

    public void setLinkInsert(List<LinkInsert> linkInsert) {
        this.linkInsert = linkInsert;
    }
}

