/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.HTSImportDuplicate;
import com.ibm.cognos.internal.hts.deployment.MetaDataUtils;
import com.ibm.cognos.internal.hts.deployment.id.IdStrategy;
import com.ibm.cognos.internal.hts.deployment.imports.LinkInsert;
import com.ibm.cognos.internal.hts.deployment.imports.TypedValue;
import com.ibm.cognos.internal.hts.deployment.imports.conflicts.ImportConflictResolver;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.dao.pojo.PersistedEquivalentLocator;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.meta.FieldMetaData;

public class TableInsert {
    private ClassMapping mapping;
    private Map<String, TypedValue> propertyMap = new HashMap<String, TypedValue>();
    private String curentPropertyName;
    private boolean importOverwrite;
    private DeploymentResources resources;
    private static boolean verbose = true;

    public TableInsert(DeploymentResources resources, ClassMapping mapping, boolean importOverwrite) {
        this.mapping = mapping;
        this.importOverwrite = importOverwrite;
        this.resources = resources;
    }

    public TableInsert(ClassMapping mapping) {
        this.mapping = mapping;
    }

    public void addProperty(String propertyName, String propertyType, String foreignKey) {
        boolean foreignBool = Boolean.valueOf(foreignKey);
        this.propertyMap.put(propertyName, new TypedValue(propertyName, propertyType, foreignBool));
        this.curentPropertyName = propertyName;
    }

    public void appendPropertyValue(String value) {
        if (this.curentPropertyName == null) {
            return;
        }
        TypedValue typedValue = this.propertyMap.get(this.curentPropertyName);
        typedValue.value = typedValue.value == null ? value : typedValue.value + value;
    }

    public String getCurentPropertyName() {
        return this.curentPropertyName;
    }

    public TypedValue getProperty(String propertyName) {
        return this.propertyMap.get(propertyName);
    }

    public void setCurentPropertyName(String curentPropertyName) {
        this.curentPropertyName = curentPropertyName;
    }

    public void setPropertyValue(String value) {
        TypedValue typedValue = this.propertyMap.get(this.curentPropertyName);
        typedValue.value = value;
    }

    public ClassMapping getMapping() {
        return this.mapping;
    }

    private void removeLinks(List<LinkInsert> linkInserts, Object object) throws HumanTaskServiceException {
        if (linkInserts != null) {
            for (LinkInsert linkInsert : linkInserts) {
                linkInsert.removeObject(object);
            }
        }
    }

    public void writeTable(List<LinkInsert> linkInserts) throws HumanTaskServiceException {
        boolean allowreferenceDuplicate;
        ObjectToStore newInstance = this.getObjectToStore();
        if (linkInserts != null) {
            for (LinkInsert linkInsert : linkInserts) {
                linkInsert.updateObject(newInstance.object);
            }
        }
        if (newInstance.existing) {
            this.removeLinks(linkInserts, newInstance.object);
            return;
        }
        boolean bl = allowreferenceDuplicate = newInstance.isImportAllowDuplicate && !newInstance.isImportBanDuplicate;
        if ((newInstance.referencesSkippedObjects || newInstance.referencesDuplicateObjects) && !allowreferenceDuplicate) {
            this.removeLinks(linkInserts, newInstance.object);
            this.saveSkippedObjectId(this.mapping, newInstance.object);
        } else {
            if (newInstance.object instanceof PersistedEquivalentLocator) {
                PersistedEquivalentLocator locator = (PersistedEquivalentLocator)PersistedEquivalentLocator.class.cast(newInstance.object);
                List<?> equivalentObjects = locator.findPersistedEquivalents(this.resources);
                if (equivalentObjects == null || equivalentObjects.size() == 0) {
                    this.writeTable(newInstance);
                } else {
                    if (equivalentObjects == null || equivalentObjects.size() != 1) {
                        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.WARN, (I18NCode)UsI18NCode.MSG_USV_DUPLICATE_DEPLOYMENT_OBJECTS, new Object[]{this.mapping.toString()});
                    }
                    this.savePersistedEquivalentId(newInstance.object, equivalentObjects.get(0));
                    this.removeLinks(linkInserts, newInstance.object);
                }
            } else {
                this.writeTable(newInstance);
            }
            if (allowreferenceDuplicate) {
                this.saveAllowreferenceDuplicate(newInstance.object);
            }
        }
    }

    private void attemptRemovalOfChildren() {
        Collection<TypedValue> properties = this.propertyMap.values();
        for (TypedValue property : properties) {
            if (property.value == null) continue;
            FieldMetaData propertyMetaData = this.mapping.getDeclaredField(property.name);
            ClassMapping propertyMapping = (ClassMapping)propertyMetaData.getDeclaredTypeMetaData();
            String value = property.value;
            if (!propertyMetaData.isDeclaredTypePC() || !property.foreignKey) continue;
            boolean isSkippedOrDuplicate = this.resources.getIdStrategy().isSkippedId(property.value, propertyMapping) || this.resources.getIdStrategy().getPersistedEquivalentId(property.value, propertyMapping) != null;
            boolean isreprievedObject = this.resources.getIdStrategy().isReprievedId(property.value, propertyMapping);
            if (value == null || isSkippedOrDuplicate || isreprievedObject) continue;
            try {
                if (verbose) {
                    Utils.debug("removing child of " + this.mapping.getTypeAlias() + " " + propertyMapping.getTypeAlias() + ": " + value);
                }
                this.resources.getPersistenceUtil().deleteById(propertyMapping.getDescribedType(), String.valueOf(value));
            }
            catch (Throwable e) {
                Utils.logException(e, UsI18NCode.MSG_USV_DEPLOYMENT_IMPORT_FAILED, new Object[]{e.getLocalizedMessage()});
            }
        }
    }

    private void saveSkippedObjectId(ClassMapping skippedMapping, Object skipped) throws HumanTaskServiceException {
        try {
            Object id = MetaDataUtils.getPrimaryKey(skipped, this.mapping);
            this.resources.getIdStrategy().addSkippedId(id, this.mapping);
            if (verbose) {
                Utils.debug("skipping " + this.mapping.getTypeAlias() + id);
            }
            ImportConflictResolver resolver = null;
            resolver = this.resources.getConflictResolverFactory().getImportConflictResolver(skippedMapping, this.resources);
            if (resolver != null) {
                resolver.skippedObject(skippedMapping, skipped);
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
    }

    private void saveAllowreferenceDuplicate(Object reprieved) throws HumanTaskServiceException {
        try {
            Object id = MetaDataUtils.getPrimaryKey(reprieved, this.mapping);
            this.resources.getIdStrategy().addReprievedId(id, this.mapping);
            if (verbose) {
                Utils.debug("flagging reprieved object " + this.mapping.getTypeAlias() + id);
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
    }

    private void savePersistedEquivalentId(Object importObject, Object persistedObject) throws HumanTaskServiceException {
        try {
            Object id = MetaDataUtils.getPrimaryKey(importObject, this.mapping);
            Object persistedId = MetaDataUtils.getPrimaryKey(persistedObject, this.mapping);
            this.resources.getIdStrategy().addPersistedEquivalentId(persistedId, id, this.mapping);
            if (verbose) {
                Utils.debug("skipping " + this.mapping.getTypeAlias() + id + " -> " + persistedId);
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
    }

    private void writeTable(ObjectToStore toWrite) throws HumanTaskServiceException {
        this.resources.getIdStrategy().prePersist(toWrite.object, this.mapping);
        if (toWrite.existing) {
            this.resources.getPersistenceUtil().update(toWrite.object);
        } else {
            this.resources.getPersistenceUtil().save(toWrite.object);
        }
        try {
            if (verbose) {
                Utils.debug("written object " + this.mapping.getTypeAlias() + ": " + MetaDataUtils.getPrimaryKey(toWrite.object, this.mapping));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resources.getIdStrategy().postPersist(toWrite.object, this.mapping);
    }

    private ObjectToStore getObjectToStore() throws HumanTaskServiceException {
        ObjectToStore newInstance = null;
        try {
            newInstance = new ObjectToStore(this.mapping.getDescribedType().newInstance());
            Collection<TypedValue> properties = this.propertyMap.values();
            for (TypedValue property : properties) {
                if (property.value == null) continue;
                FieldMetaData propertyMetaData = this.mapping.getDeclaredField(property.name);
                ClassMapping propertyMapping = (ClassMapping)propertyMetaData.getDeclaredTypeMetaData();
                Object value = property.value;
                if (propertyMetaData.isDeclaredTypePC() && property.foreignKey && value != null) {
                    IdStrategy idStrat = this.resources.getIdStrategy();
                    Object newId = null;
                    newId = idStrat.getPersistedEquivalentId(property.value, propertyMapping);
                    if (newId != null) {
                        newInstance.referencesDuplicateObjects = true;
                        if (verbose) {
                            Utils.debug(this.mapping.getTypeAlias() + " refs " + propertyMapping.getTypeAlias() + " duplicate id " + property.value);
                        }
                        this.isAllowDuplicateField(newInstance, propertyMetaData.getName());
                    } else if (idStrat.isSkippedId(property.value, propertyMapping)) {
                        newInstance.referencesSkippedObjects = true;
                        if (verbose) {
                            Utils.debug(this.mapping.getTypeAlias() + " refs " + propertyMapping.getTypeAlias() + " skipped id " + property.value);
                        }
                        this.isAllowDuplicateField(newInstance, propertyMetaData.getName());
                    } else {
                        newId = idStrat.getNewId(property.value, propertyMapping);
                    }
                    value = this.resources.getPersistenceUtil().loadById(propertyMetaData.getDeclaredType(), String.valueOf(newId));
                    if (value == null) {
                        ImportConflictResolver resolver = null;
                        resolver = this.resources.getConflictResolverFactory().getImportConflictResolver(propertyMapping, this.resources);
                        if (resolver != null) {
                            if (verbose) {
                                Utils.debug("attempting to resolve import conflict - foreign key id from " + this.mapping.getTypeAlias() + " to " + propertyMapping.getTypeAlias() + ": " + newId + " returned null");
                            }
                            if ((value = resolver.resolveConflict(this.mapping, newInstance.object, propertyMapping, property.value, properties)) != null) {
                                newInstance.referencesSkippedObjects = false;
                            }
                        } else {
                            newInstance.referencesSkippedObjects = true;
                            if (verbose) {
                                Utils.debug("WARNING: Import references another object that could not be imported - foreign key id from " + this.mapping.getTypeAlias() + " to " + propertyMapping.getTypeAlias() + ": " + newId + " returned null");
                            }
                        }
                    }
                }
                MetaDataUtils.setPropertyValue(propertyMetaData, newInstance.object, value);
            }
            if (this.resources.getIdStrategy().doExistingCheck()) {
                Object pk = MetaDataUtils.getPrimaryKey(newInstance.object, this.mapping);
                Object existing = this.resources.getPersistenceUtil().loadById(newInstance.object.getClass(), String.valueOf(pk));
                if (existing != null) {
                    newInstance.object = existing;
                    newInstance.existing = true;
                    this.resources.getIdStrategy().addPersistedEquivalentId(pk, pk, this.mapping);
                    if (verbose) {
                        Utils.debug("existing " + this.mapping.getTypeAlias() + " id " + pk);
                    }
                }
            }
        }
        catch (Exception e) {
            Utils.logException(e);
            throw new HumanTaskServiceException(UsI18NCode.MSG_USV_DEPLOYMENT_METADATA_MISMATCH, new Object[]{e.getLocalizedMessage(), e});
        }
        return newInstance;
    }

    private void isAllowDuplicateField(ObjectToStore newInstance, String propertyMetaDataName) throws SecurityException, NoSuchFieldException {
        Annotation allowDuplicate = null;
        allowDuplicate = MetaDataUtils.getFieldWithAnnotation(HTSImportDuplicate.class, propertyMetaDataName, newInstance.object);
        if (allowDuplicate != null) {
            HTSImportDuplicate duper = (HTSImportDuplicate)allowDuplicate;
            if (duper.allow()) {
                newInstance.isImportAllowDuplicate = true;
            } else {
                newInstance.isImportBanDuplicate = true;
            }
        }
    }

    private class ObjectToStore {
        public Object object;
        public boolean referencesDuplicateObjects = false;
        public boolean referencesSkippedObjects = false;
        public boolean isImportAllowDuplicate = false;
        public boolean isImportBanDuplicate = false;
        public boolean existing = false;
        public LinkInsert linkInsert;

        public ObjectToStore(Object object) {
            this.object = object;
        }
    }
}

