/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports.conflicts;

import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.imports.TypedValue;
import com.ibm.cognos.internal.hts.deployment.imports.conflicts.ImportConflictResolver;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.DeadlinesDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadline;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadlineInstance;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.openjpa.jdbc.meta.ClassMapping;

public class DeadlineInstanceConflictResolver
extends ImportConflictResolver {
    private DeploymentResources resources;
    private List<HTSDeadline> skippedDeadlines = new ArrayList<HTSDeadline>();

    public DeadlineInstanceConflictResolver(DeploymentResources resources) {
        this.resources = resources;
    }

    @Override
    public Object resolveConflict(ClassMapping ownerMapping, Object owner, ClassMapping childMapping, Object child, Collection<TypedValue> properties) {
        HTSDeadline deadline;
        HTSDeadline liveLine = null;
        if (owner instanceof HTSDeadlineInstance && (deadline = this.findSkippedDeadline(child)) != null) {
            String taskId = null;
            for (TypedValue typedValue : properties) {
                if (!typedValue.getName().equals("htsTask")) continue;
                taskId = typedValue.getValue();
            }
            liveLine = this.findLiveDeadline((HTSDeadlineInstance)owner, deadline, taskId);
        }
        return liveLine;
    }

    private HTSDeadline findLiveDeadline(HTSDeadlineInstance instance, HTSDeadline deadline, String taskId) {
        DeadlinesDAO dao = DAOFactory.getFactory().buildDeadlinesDAO();
        List<HTSDeadline> deadlines = dao.findByAttributes(this.resources.getPersistenceUtil().getEntityManager(), deadline.getHtsDeadlinetype(), deadline.getTimeForExpression(), deadline.getTimeUntilExpression());
        HTSDeadline theOne = null;
        HTSTask task = (HTSTask)this.resources.getPersistenceUtil().loadById(HTSTask.class, taskId);
        HTSTaskclass tc = task.getHtsTaskclass();
        for (HTSDeadline live : deadlines) {
            HTSTaskclass dtc;
            if (live.getId().equals(deadline.getId()) || (dtc = dao.findDeadlineTaskClass(this.resources.getPersistenceUtil().getEntityManager(), live)) == null || !dtc.getId().equals(tc.getId())) continue;
            theOne = live;
        }
        return theOne;
    }

    private HTSDeadline findSkippedDeadline(Object skippedId) {
        HTSDeadline deadline = null;
        for (HTSDeadline skippedDeadline : this.skippedDeadlines) {
            if (!skippedDeadline.getId().equals(skippedId)) continue;
            deadline = skippedDeadline;
            break;
        }
        return deadline;
    }

    @Override
    public void skippedObject(ClassMapping mapping, Object object) {
        if (object instanceof HTSDeadline) {
            this.skippedDeadlines.add((HTSDeadline)object);
        }
    }
}

