/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports.fixup;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.imports.ImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.PojoImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.TableInsert;
import com.ibm.cognos.internal.hts.deployment.imports.TypedValue;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.FixedUpId;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.FixupImportDelegate;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import java.util.Iterator;
import java.util.List;

class AnnotationFixupImportDelegate
extends FixupImportDelegate {
    private static final String FIXUP_PARENT_PROPERTY = "parentId";
    private static final String FIXUP_SECONDPARENT_PROPERTY = "secondaryParentId";
    private static final String FIXUP_OWNER_PROPERTY = "owner";

    public AnnotationFixupImportDelegate(ImportDelegate parent, boolean importOverwrite, DeploymentResources resources) {
        super(parent, importOverwrite, resources);
    }

    @Override
    protected void doFixUp(List<FixedUpId> fixedUpIds) {
        if (!(this.getParent() instanceof PojoImportDelegate)) {
            return;
        }
        PojoImportDelegate pojoDelegate = (PojoImportDelegate)this.getParent();
        TableInsert insert = pojoDelegate.getPendingInsert();
        this.fixupProperty(fixedUpIds, insert, FIXUP_PARENT_PROPERTY);
        this.fixupProperty(fixedUpIds, insert, FIXUP_SECONDPARENT_PROPERTY);
        this.fixupProperty(fixedUpIds, insert, FIXUP_OWNER_PROPERTY);
    }

    private void fixupProperty(List<FixedUpId> fixedUpIds, TableInsert insert, String propertyName) {
        TypedValue value = insert.getProperty(propertyName);
        FixedUpId fixup = null;
        if (value != null && value.getValue() != null) {
            Iterator<FixedUpId> it = fixedUpIds.iterator();
            while (it.hasNext() && fixup == null) {
                FixedUpId fixupInList = it.next();
                if (!fixupInList.getOriginalId().equals(value.getValue())) continue;
                fixup = fixupInList;
            }
            if (fixup == null || fixup.getFixedUpId() == null) {
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_USV_IMPORT_DEPLOYMENT_FIXUP_FAILED, new Object[0]);
            } else {
                value.setValue(fixup.getFixedUpId());
            }
        }
    }
}

