/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports.fixup;

import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeploymentSearchpathTranslations {
    Properties props = new Properties();
    private Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    public DeploymentSearchpathTranslations() throws HumanTaskServiceException {
        try {
            InputStream propsIn = this.getClass().getResourceAsStream("./HTSDeploymentSearchpathTranslations.properties");
            if (propsIn != null) {
                this.props.load(propsIn);
            }
        }
        catch (IOException e) {
            Utils.throwHumanTaskServiceException(e);
        }
    }

    public void setTranslationProperty(String path, String newPath) {
        this.props.put(path, newPath);
    }

    private Pattern getPattern(String key) {
        if (!this.patterns.containsKey(key)) {
            this.patterns.put(key, Pattern.compile(key));
        }
        return this.patterns.get(key);
    }

    public String transformSearchPath(String path) {
        for (Object key : this.props.keySet()) {
            Pattern pattern = this.getPattern(key.toString());
            Matcher matcher = pattern.matcher(path);
            if (!matcher.find()) continue;
            path = matcher.replaceAll(this.props.getProperty(key.toString()));
        }
        return path;
    }
}

