/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports.fixup;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.AxisUtils;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.imports.ImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.FixedUpId;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.List;
import java.util.Stack;
import org.apache.axis.client.Stub;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class FixupImportDelegate
extends ImportDelegate {
    private static final String CMREFS = "cmReferences";
    private static final String CMREF = "cmReference";
    private static final String ID = "id";
    private static final String SEARCH_PATH = "searchPath";
    private String currentProperty;
    private String id = "";
    private String searchPath = "";
    private Stack<FixedUpId> fixupIds;
    private static String SEARCHPATH_MARKER = "@@SEARCHPATHMARKER@@";

    public FixupImportDelegate(ImportDelegate parent, boolean importOverwrite, DeploymentResources resources) {
        super(parent, importOverwrite, resources);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentProperty.equals(ID)) {
            this.id = this.id + new String(ch, start, length);
        } else if (this.currentProperty.equals(SEARCH_PATH)) {
            this.searchPath = this.searchPath + new String(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            if (name.equals(CMREFS)) {
                this.doFixUp(this.fixupIds);
                this.fixupIds = null;
                this.getParent().setDelegate(null);
            } else if (name.equals(CMREF)) {
                FixedUpId fixedUpId = new FixedUpId(this.id, this.searchPath);
                this.getStoreId(this.getResources(), fixedUpId);
                this.fixupIds.push(fixedUpId);
                this.id = "";
                this.searchPath = "";
            } else if (name.equals(SEARCH_PATH)) {
                this.searchPath = this.getResources().getSearchPathTranslations().transformSearchPath(this.searchPath);
            }
        }
        catch (HumanTaskServiceException e) {
            Utils.logException((Throwable)((Object)e), UsI18NCode.MSG_USV_IMPORT_DEPLOYMENT_FIXUP_FAILED, new Object[]{e.getMessage()});
            throw new SAXException((Exception)((Object)e));
        }
        this.currentProperty = null;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals(CMREFS)) {
            this.fixupIds = new Stack();
        }
        this.currentProperty = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getStoreId(DeploymentResources resources, FixedUpId fixup) throws HumanTaskServiceException {
        if (SEARCHPATH_MARKER.equals(fixup.getSearchpath())) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_USV_DEPLOYMENT_IMPORT_FAILED, new Object[]{fixup.getOriginalId()});
            return;
        }
        ContentManagerServiceClientPort cmPort = null;
        try {
            JobBiBusHeaders headers = resources.getLoggedInHeader();
            cmPort = Client.instance().getContentManagerServiceClient(headers);
            AxisUtils.setHeader((Stub)cmPort.getBinding(), (BiBusHeader)headers.getBiBusHeader());
            QueryRequest request = new QueryRequest();
            request.setSearch(fixup.getSearchpath());
            request.setProperties(new PropEnum[]{PropEnum.storeID});
            BaseClass reply = cmPort.query(request);
            if (reply != null) {
                fixup.setFixedUpId(reply.getStoreID().getValue().get_value());
            }
        }
        catch (Exception e) {
            Utils.logException(e, UsI18NCode.MSG_USV_DEPLOYMENT_IMPORT_FAILED, new Object[]{e.getMessage()});
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
    }

    protected abstract void doFixUp(List<FixedUpId> var1) throws HumanTaskServiceException;
}

