/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports.fixup;

import com.ibm.cognos.internal.annotations.pojos.Annotation;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.imports.ImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.TableInsert;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.AnnotationFixupImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.CMTasUserFixupImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.FixupImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.TaskMessageFixupImportDelegate;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class FixupImportDelegateFactory {
    private Map<Class<?>, Class<? extends FixupImportDelegate>> delegateMap = new HashMap();

    public FixupImportDelegateFactory() {
        this.delegateMap.put(Annotation.class, AnnotationFixupImportDelegate.class);
        this.delegateMap.put(HTSMessage.class, TaskMessageFixupImportDelegate.class);
        this.delegateMap.put(HTSTaskUser.class, CMTasUserFixupImportDelegate.class);
    }

    public FixupImportDelegate getFixupImportDelegate(TableInsert currentInsert, ImportDelegate delegate, boolean importOverwrite, DeploymentResources resources) throws HumanTaskServiceException {
        Class<? extends FixupImportDelegate> delegateType = this.delegateMap.get(currentInsert.getMapping().getDescribedType());
        FixupImportDelegate delegateInstance = null;
        try {
            Constructor<? extends FixupImportDelegate> constructor = delegateType.getConstructor(ImportDelegate.class, Boolean.TYPE, DeploymentResources.class);
            delegateInstance = constructor.newInstance(delegate, importOverwrite, resources);
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_IMPORT_DEPLOYMENT_FIXUP_FAILED, new Object[]{e.getMessage()});
        }
        return delegateInstance;
    }

    public void setFixupImportDelegate(Class<?> pojoClass, Class<? extends FixupImportDelegate> fixupdelegateClass) {
        this.delegateMap.put(pojoClass, fixupdelegateClass);
    }
}

