/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.deployment.imports.fixup;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.imports.ImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.PojoImportDelegate;
import com.ibm.cognos.internal.hts.deployment.imports.TableInsert;
import com.ibm.cognos.internal.hts.deployment.imports.TypedValue;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.FixedUpId;
import com.ibm.cognos.internal.hts.deployment.imports.fixup.FixupImportDelegate;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import java.util.List;

public class TaskMessageFixupImportDelegate
extends FixupImportDelegate {
    private static final String FIXUP_PROPERTY = "message";

    public TaskMessageFixupImportDelegate(ImportDelegate parent, boolean importOverwrite, DeploymentResources resources) {
        super(parent, importOverwrite, resources);
    }

    @Override
    protected void doFixUp(List<FixedUpId> fixedUpIds) {
        if (!(this.getParent() instanceof PojoImportDelegate)) {
            return;
        }
        PojoImportDelegate pojoDelegate = (PojoImportDelegate)this.getParent();
        TableInsert insert = pojoDelegate.getPendingInsert();
        TypedValue value = insert.getProperty(FIXUP_PROPERTY);
        for (FixedUpId fixedUpId : fixedUpIds) {
            if (value == null || fixedUpId == null || fixedUpId.getFixedUpId() == null || value.getValue() == null || !value.getValue().contains(fixedUpId.getOriginalId())) {
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_USV_IMPORT_DEPLOYMENT_FIXUP_FAILED, new Object[0]);
                continue;
            }
            String replaced = value.getValue().replace(fixedUpId.getOriginalId(), fixedUpId.getFixedUpId());
            value.setValue(replaced);
        }
    }
}

