/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.event;

import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.event.TaskUpdate;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.AuditLogParam;
import com.ibm.cognos.internal.hts.util.TaskPriorityEnum;

public class TaskUpdatePriority
extends TaskUpdate {
    private int m_oldPriority;
    private int m_newPriority;

    public TaskUpdatePriority(IAbstractContext context, int oldPriority, int newPriority) {
        super(context, TaskUpdate.Type.UPDATE);
        this.m_oldPriority = oldPriority;
        this.m_newPriority = newPriority;
    }

    public int getOldPriority() {
        return this.m_oldPriority;
    }

    public int getNewPriority() {
        return this.m_newPriority;
    }

    @Override
    public AuditLogParam[] getAuditParams() {
        AuditLogParam oldParam = new AuditLogParam(AuditLogParam.Type.STRING, TaskPriorityEnum.parseIntValue(this.m_oldPriority).toString());
        AuditLogParam newParam = new AuditLogParam(AuditLogParam.Type.STRING, TaskPriorityEnum.parseIntValue(this.m_newPriority).toString());
        return new AuditLogParam[]{oldParam, newParam};
    }

    @Override
    public UsI18NCode getAuditI18NCode() {
        return UsI18NCode.MSG_HTS_TASKUPDATE_PRIORITY;
    }
}

