/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.event;

import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.event.TaskUpdate;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.AuditLogParam;

public class TaskUpdateStartDeadline
extends TaskUpdate {
    private long m_oldDeadline;
    private long m_newDeadline;

    public TaskUpdateStartDeadline(IAbstractContext context, long oldDeadline, long newDeadline) {
        super(context, TaskUpdate.Type.UPDATE);
        this.m_oldDeadline = oldDeadline;
        this.m_newDeadline = newDeadline;
    }

    public TaskUpdateStartDeadline(IAbstractContext context, long newDeadline) {
        super(context, TaskUpdate.Type.ADD);
        this.m_newDeadline = newDeadline;
    }

    public TaskUpdateStartDeadline(IAbstractContext context) {
        super(context, TaskUpdate.Type.REMOVE);
    }

    public long getOldDeadline() {
        return this.m_oldDeadline;
    }

    public long getNewDeadline() {
        return this.m_newDeadline;
    }

    @Override
    public AuditLogParam[] getAuditParams() {
        if (this.getType().equals((Object)TaskUpdate.Type.ADD)) {
            AuditLogParam newParam = new AuditLogParam(AuditLogParam.Type.DATE_LONG, Long.toString(this.m_newDeadline));
            return new AuditLogParam[]{newParam};
        }
        if (this.getType().equals((Object)TaskUpdate.Type.UPDATE)) {
            AuditLogParam oldParam = new AuditLogParam(AuditLogParam.Type.DATE_LONG, Long.toString(this.m_oldDeadline));
            AuditLogParam newParam = new AuditLogParam(AuditLogParam.Type.DATE_LONG, Long.toString(this.m_newDeadline));
            return new AuditLogParam[]{oldParam, newParam};
        }
        if (this.getType().equals((Object)TaskUpdate.Type.REMOVE)) {
            return new AuditLogParam[0];
        }
        return null;
    }

    @Override
    public UsI18NCode getAuditI18NCode() {
        if (this.getType().equals((Object)TaskUpdate.Type.ADD)) {
            return UsI18NCode.MSG_HTS_TASKUPDATE_ADD_START_DEADLINE;
        }
        if (this.getType().equals((Object)TaskUpdate.Type.UPDATE)) {
            return UsI18NCode.MSG_HTS_TASKUPDATE_UPDATE_START_DEADLINE;
        }
        if (this.getType().equals((Object)TaskUpdate.Type.REMOVE)) {
            return UsI18NCode.MSG_HTS_TASKUPDATE_REMOVE_START_DEADLINE;
        }
        return null;
    }
}

