/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.logging;

import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.event.EVENT_TYPE;
import com.ibm.cognos.internal.hts.event.Event;
import com.ibm.cognos.internal.hts.event.TaskUpdate;
import com.ibm.cognos.internal.hts.event.USEventListener;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.AuditLogParam;
import com.ibm.cognos.internal.hts.logging.AuditLogUtil;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.CommentUtil;
import com.ibm.cognos.internal.hts.util.dao.builder.AuditBuilder;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.AuditMessageDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.AuditParam;

public class AuditLogEventListener
implements USEventListener {
    @Override
    public void handleEvent(Event event) throws HumanTaskServiceException {
        if (event.getEventType() == EVENT_TYPE.TASKUPDATE_EVENT) {
            TaskUpdate taskUpdate = (TaskUpdate)event.getEventObject();
            UsI18NCode code = taskUpdate.getAuditI18NCode();
            AuditLogParam[] params = taskUpdate.getAuditParams();
            IAbstractContext context = taskUpdate.getContext();
            int level = 1;
            AuditMessageDocument audit = this.getAuditMessageDocument(context, code, params, level);
            this.insertAudit(context, audit);
        }
    }

    public AuditMessageDocument getAuditMessageDocument(IAbstractContext context, UsI18NCode msg, AuditLogParam[] params, int level) throws HumanTaskServiceException {
        AuditMessageDocument audit = AuditMessageDocument.Factory.newInstance();
        audit.addNewAuditMessage().setI18Ncode(msg.getCode());
        audit.getAuditMessage().setLevel(level);
        for (int i = 0; i < params.length; ++i) {
            AuditParam auditParam = audit.getAuditMessage().addNewParam();
            auditParam.setType(AuditLogUtil.getParamType(params[i]));
            auditParam.setStringValue(params[i].getValue());
        }
        return audit;
    }

    public void insertAudit(IAbstractContext context, AuditMessageDocument audit) throws HumanTaskServiceException {
        HTSTask task = context.getPersistedTask();
        AuditBuilder builder = new AuditBuilder(audit, task, UserUtils.instance().getUser(context.getHeader()));
        CommentUtil.insertComment(context, builder);
    }
}

