/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.logging;

import com.ibm.cognos.internal.hts.logging.EMFDefaultLogger;
import com.ibm.cognos.internal.hts.logging.IEMFLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;

public class EMFDefaultLogFactory {
    public static final String DEFAULT_LOG_PROPERTIES = "defaultLog.properties";
    public static final String PA_INSTALL_DIR = "pa-install-dir";

    public EMFDefaultLogFactory() {
        File defaultLogProperties = new File(PA_INSTALL_DIR, DEFAULT_LOG_PROPERTIES);
        Properties logProperties = new Properties();
        try {
            FileInputStream propertiesInputStream = new FileInputStream(defaultLogProperties);
            logProperties.load(propertiesInputStream);
        }
        catch (IOException e) {
            System.err.println("Problem loading defaultLog.properties, logging output will not be enabled");
            return;
        }
        PropertiesConfigurationBuilder propconfigbuilder = new PropertiesConfigurationBuilder();
        PropertiesConfiguration propconfig = propconfigbuilder.build();
        propconfig.reconfigure();
    }

    public IEMFLogger getLogger(String name) {
        return new EMFDefaultLogger(LogManager.getLogger((String)name));
    }

    public IEMFLogger getLogger(Class clazz) {
        return new EMFDefaultLogger(LogManager.getLogger((Class)clazz));
    }
}

