/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.logging;

import com.ibm.cognos.internal.hts.apiHandlers.CreateEmailNotificationTaskHandler;
import com.ibm.cognos.internal.hts.service.ws_ht.HandlerMapFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class IPFLogOperationsMap {
    private static IPFLogOperationsMap ipfLogOperationsMap = null;
    private HashMap<IPFLogOperation, ArrayList> logOperationsMap = null;
    private ArrayList<String> operations = null;

    private IPFLogOperationsMap() {
        List<String> emailOps = HandlerMapFactory.getHandlerMap().getOperationsForHandler(CreateEmailNotificationTaskHandler.class);
        this.logOperationsMap = new HashMap();
        this.operations = new ArrayList();
        this.operations.add("addComment");
        this.logOperationsMap.put(IPFLogOperation.IPF_LOG_COMMENTS, this.operations);
        this.operations = new ArrayList();
        this.operations.add("changeSubscription");
        this.logOperationsMap.put(IPFLogOperation.IPF_LOG_SUBSCRIPTIONS, this.operations);
        this.operations = new ArrayList();
        this.operations.add("claim");
        this.operations.add("release");
        this.operations.add("forward");
        this.operations.add("delegate");
        this.operations.add("activate");
        this.operations.add("nominate");
        this.operations.add("setGenericHumanRole");
        this.operations.add("humanInteractions");
        this.operations.add("reassign");
        this.operations.add("createAcknowledgeManualTask");
        this.operations.add("createAgentUserTask");
        this.operations.add("createAnyUserTask");
        this.operations.add("createApproveManualTask");
        this.operations.add("createGenericManualTask");
        this.operations.addAll(emailOps);
        this.operations.add("createNotificationManualTask");
        this.operations.add("createPushNotificationTask");
        this.logOperationsMap.put(IPFLogOperation.IPF_LOG_HUMANROLES, this.operations);
        this.operations = new ArrayList();
        this.operations.addAll(emailOps);
        this.logOperationsMap.put(IPFLogOperation.IPF_LOG_NOTIFICATIONS, this.operations);
    }

    public static IPFLogOperationsMap getInstance() {
        if (ipfLogOperationsMap == null) {
            ipfLogOperationsMap = new IPFLogOperationsMap();
        }
        return ipfLogOperationsMap;
    }

    public boolean doIPFLogging(IPFLogOperation ipfLogOperation, String userServiceOperation) {
        ArrayList operationsList;
        boolean doLogging = false;
        if (ipfLogOperation != null && userServiceOperation != null && (operationsList = this.logOperationsMap.get((Object)ipfLogOperation)) != null) {
            doLogging = operationsList.contains(userServiceOperation);
        }
        return doLogging;
    }

    public static enum IPFLogOperation {
        IPF_LOG_HUMANROLES,
        IPF_LOG_NOTIFICATIONS,
        IPF_LOG_COMMENTS,
        IPF_LOG_SUBSCRIPTIONS,
        IPF_LOG_TASKMESSAGES;

    }
}

