/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.logging;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.ibm.cognos.internal.hts.apiHandlers.context.AddCommentContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.ChangeSubscriptionContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.CreateEmailNotificatonTaskContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.HTSVersionInfo;
import com.ibm.cognos.internal.hts.logging.IPFLogOperationsMap;
import com.ibm.cognos.internal.hts.logging.LogOperations;
import com.ibm.cognos.internal.hts.logging.LogTypedLoggerWrapper;
import com.ibm.cognos.internal.hts.logging.LogTypedLoggerWrapperImpl;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.logging.ipf.castor.HumanTaskServiceActivityLog;
import com.ibm.cognos.internal.hts.logging.ipf.castor.Humanrole;
import com.ibm.cognos.internal.hts.logging.ipf.castor.HumanroleList;
import com.ibm.cognos.internal.hts.logging.ipf.castor.LogEntry;
import com.ibm.cognos.internal.hts.logging.ipf.castor.Notification;
import com.ibm.cognos.internal.hts.logging.ipf.castor.NotificationList;
import com.ibm.cognos.internal.hts.logging.ipf.castor.SubscriptionChange;
import com.ibm.cognos.internal.hts.logging.ipf.castor.SubscriptionChangeList;
import com.ibm.cognos.internal.hts.logging.ipf.castor.TaskMessage;
import com.ibm.cognos.internal.hts.logging.ipf.castor.TaskMessageList;
import com.ibm.cognos.internal.hts.notification.NotificationDetails;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceOperations;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.builder.PresentationElementsBuilder;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.ChangeSubscriptionDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.Subscription;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class IPFLogger
implements HumanTaskServiceOperations {
    private static Map<String, LogTypedLogger> m_logger_map = new HashMap<String, LogTypedLogger>();
    private static final String HTS_CATEGORY = "Audit.RTUsage.HTS";
    private LogTypedLoggerWrapper audit = null;
    private int build_number = HTSVersionInfo.getBuild();
    private LogAuditAccessIndication indication;

    public IPFLogger(LogTypedLoggerWrapper wrapper) {
        this.audit = wrapper;
    }

    public IPFLogger() {
        this.audit = this.getLogger(HTS_CATEGORY);
    }

    public void logServiceStart(BiBusHeader header) throws HumanTaskServiceException {
        if (this.audit.isEnabled(50000)) {
            TrackingInfo info = this.getTrackingInfo(header);
            LogAuditAccessIndication indication = this.getIndication();
            indication.setLevel(50000);
            indication.setOperation("StartService");
            indication.setRequestID(info.requestId);
            indication.setSessionID(info.sessionId);
            indication.setStatus("Success");
            indication.setStepID(info.stepId);
            indication.setSubRequestID(info.subrequestId);
            this.audit.log(indication);
        }
    }

    public void logServiceStop(BiBusHeader header) throws HumanTaskServiceException {
        if (this.audit.isEnabled(50000)) {
            TrackingInfo info = this.getTrackingInfo(header);
            LogAuditAccessIndication indication = this.getIndication();
            indication.setLevel(50000);
            indication.setOperation("StopService");
            indication.setRequestID(info.requestId);
            indication.setSessionID(info.sessionId);
            indication.setStatus("Success");
            indication.setStepID(info.stepId);
            indication.setSubRequestID(info.subrequestId);
            this.audit.log(indication);
        }
    }

    public void logCurrentOperation(IAbstractContext context) throws HumanTaskServiceException {
        this.log(context, "Success");
    }

    private void log(IAbstractContext context, String status) throws HumanTaskServiceException {
        try {
            String operation = context.getOperationName();
            int level = LogOperations.getIPFLevel(operation);
            if (level != -1) {
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("USV: Logging IPF log details for operation : " + operation);
                this.insertAuditLogIfEnabled(context, level, status);
            }
        }
        catch (HumanTaskServiceException usvex) {
            Utils.logException((Throwable)((Object)usvex));
            throw usvex;
        }
        catch (Exception ex) {
            Utils.logException(ex, UsI18NCode.MSG_US_ERROR_LOGGING_IPF_LOG_DATA, new Object[0]);
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_ERROR_LOGGING_IPF_LOG_DATA);
        }
    }

    private void insertAuditLogIfEnabled(IAbstractContext context, int level, String status) throws HumanTaskServiceException {
        try {
            boolean enabled = false;
            enabled = this.audit.isEnabled(30000);
            if (this.audit.isEnabled(30000)) {
                this.insertAuditLog(context, level, status);
            }
        }
        catch (HumanTaskServiceException usvex) {
            Utils.logException((Throwable)((Object)usvex));
            throw usvex;
        }
        catch (Exception ex) {
            Utils.logException(ex, UsI18NCode.MSG_US_ERROR_LOGGING_IPF_LOG_DATA, new Object[0]);
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_ERROR_LOGGING_IPF_LOG_DATA);
        }
    }

    private LogAuditAccessIndication getIndication() {
        LogAuditAccessIndication indication = new LogAuditAccessIndication("HTS", this.build_number);
        indication.setObjectType("HumanTaskServiceTask");
        return indication;
    }

    private void insertAuditLog(IAbstractContext context, int level, String status) throws HumanTaskServiceException {
        String logData = null;
        TrackingInfo info = null;
        LogAuditAccessIndication indication = null;
        try {
            indication = this.getIndication();
            indication.setLevel(30000);
            if (context.getPersistedTask() != null) {
                indication.setObjectPath(context.getPersistedTask().getName());
            }
            indication.setOperation(this.getIPFOperation(context.getOperationName()));
            info = this.getTrackingInfo(context);
            if (info == null) {
                throw new HumanTaskServiceException(UsI18NCode.MSG_US_ERROR_LOGGING_IPF_LOG_DATA);
            }
            indication.setRequestID(info.requestId);
            indication.setStepID(info.stepId);
            indication.setSessionID(info.sessionId);
            indication.setStatus(status);
            indication.setSubRequestID(info.subrequestId);
            indication.setTime(System.currentTimeMillis());
            logData = this.generateLogData(context);
            indication.setLogData(logData);
            this.audit.log(indication);
            this.indication = indication;
        }
        catch (HumanTaskServiceException usvex) {
            Utils.logException((Throwable)((Object)usvex));
            throw usvex;
        }
        catch (Exception ex) {
            Utils.logException(ex, UsI18NCode.MSG_US_ERROR_LOGGING_IPF_LOG_DATA, new Object[0]);
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_ERROR_LOGGING_IPF_LOG_DATA);
        }
    }

    private String generateLogData(IAbstractContext context) throws HumanTaskServiceException {
        String logData = "";
        HTSTask task = null;
        HumanTaskServiceActivityLog htsActivityLog = new HumanTaskServiceActivityLog();
        LogEntry logEntry = new LogEntry();
        PresentationElementsBuilder presentationElementsBuilder = null;
        try {
            task = context.getPersistedTask();
            if (task != null) {
                logEntry.setTaskId(task.getId());
                logEntry.setTransactionType(context.getOperationName());
                if (context.getUsTaskUser() != null) {
                    logEntry.setUser(context.getUsTaskUser().getUserToken());
                }
                if (task.getPriority() != null) {
                    logEntry.setPriority(task.getPriority());
                }
                logEntry.setStatus(task.getStatus());
                if (task.getActivationTime() != null) {
                    logEntry.setActivationTime(task.getActivationTime());
                }
                if (task.getExpirationTime() != null) {
                    logEntry.setExpirationTime(task.getExpirationTime());
                }
                presentationElementsBuilder = new PresentationElementsBuilder(task, context);
                logEntry.setName(presentationElementsBuilder.getName());
                logEntry.setSubject(presentationElementsBuilder.getSubject(context.getLanguage()));
                logEntry.setDescription(presentationElementsBuilder.getDescription(context.getLanguage()));
                logEntry.setTimezoneId(task.getTimezone());
                if (task.getActualOwner() != null) {
                    logEntry.setActualOwner(task.getActualOwner().getUserToken());
                }
                if (task.getTaskInitiator() != null) {
                    logEntry.setInitiator(task.getTaskInitiator().getUserToken());
                }
                if (task.getHtsTaskclass() != null) {
                    logEntry.setClassName(task.getHtsTaskclass().getName());
                    logEntry.setClassOperation(task.getHtsTaskclass().getOperation());
                }
            } else {
                throw new HumanTaskServiceException(UsI18NCode.MSG_US_ERROR_GENERATING_LOG_DATA);
            }
            logEntry.setComment(this.generateTaskCommentLogData(context));
            logEntry.setTaskMessageList(this.generateTaskMessageLogData(context));
            logEntry.setNotificationList(this.generateNotificationLogData(context));
            logEntry.setSubscriptionChangeList(this.generateSubscriptionChangeLogData(context));
            logEntry.setHumanroleList(this.generateHumanroleLogData(context));
            htsActivityLog.addLogEntry(logEntry);
            StringWriter castorStr = new StringWriter();
            Marshaller m = new Marshaller((Writer)castorStr);
            m.marshal((Object)htsActivityLog);
            logData = castorStr.toString();
        }
        catch (HumanTaskServiceException usvex) {
            Utils.logException((Throwable)((Object)usvex));
            throw usvex;
        }
        catch (ValidationException vex) {
            Utils.logException(vex, UsI18NCode.MSG_US_ERROR_GENERATING_LOG_DATA, new Object[0]);
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_ERROR_GENERATING_LOG_DATA);
        }
        catch (MarshalException mex) {
            Utils.logException(mex, UsI18NCode.MSG_US_ERROR_GENERATING_LOG_DATA, new Object[0]);
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_ERROR_GENERATING_LOG_DATA);
        }
        catch (IOException ioex) {
            Utils.logException(ioex, UsI18NCode.MSG_US_ERROR_GENERATING_LOG_DATA, new Object[0]);
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_ERROR_GENERATING_LOG_DATA);
        }
        return logData;
    }

    private String getIPFOperation(String taskOperationName) {
        String ipfOperation = "Update";
        if (taskOperationName != null && ("createAcknowledgeManualTask".equalsIgnoreCase(taskOperationName) || "createAgentUserTask".equalsIgnoreCase(taskOperationName) || "createAnyUserTask".equalsIgnoreCase(taskOperationName) || "createApproveManualTask".equalsIgnoreCase(taskOperationName) || "createNotificationManualTask".equalsIgnoreCase(taskOperationName) || "createPushNotificationTask".equalsIgnoreCase(taskOperationName) || "createGenericManualTask".equalsIgnoreCase(taskOperationName) || "createEmailNotificationTask".equalsIgnoreCase(taskOperationName) || "createChildTasks".equalsIgnoreCase(taskOperationName))) {
            ipfOperation = "Create";
        }
        return ipfOperation;
    }

    private HumanroleList generateHumanroleLogData(IAbstractContext context) {
        HumanroleList humanroleList = null;
        Humanrole humanrole = null;
        HTSTask task = null;
        try {
            List<HTSHumanRole> humanroles;
            if (context != null && IPFLogOperationsMap.getInstance().doIPFLogging(IPFLogOperationsMap.IPFLogOperation.IPF_LOG_HUMANROLES, context.getOperationName()) && (task = context.getPersistedTask()) != null && (humanroles = task.getHtsHumanRoles()) != null) {
                humanroleList = new HumanroleList();
                for (HTSHumanRole hTSHumanRole : humanroles) {
                    humanrole = new Humanrole();
                    humanrole.setRole(hTSHumanRole.getHtsRole().getRole());
                    humanrole.setUser(hTSHumanRole.getHtsTaskUser().getUserToken());
                    humanroleList.addHumanrole(humanrole);
                }
            }
        }
        catch (Exception ex) {
            Utils.logException(ex, UsI18NCode.MSG_US_ERROR_GENERATING_TASK_HUMANROLE_LOG_DATA, new Object[0]);
        }
        return humanroleList;
    }

    private SubscriptionChangeList generateSubscriptionChangeLogData(IAbstractContext context) {
        SubscriptionChangeList subscriptionChangeList = null;
        Object subscriptionChange = null;
        ChangeSubscriptionContext changeSubscriptionContext = null;
        Object eventType = null;
        try {
            if (context != null && IPFLogOperationsMap.getInstance().doIPFLogging(IPFLogOperationsMap.IPFLogOperation.IPF_LOG_SUBSCRIPTIONS, context.getOperationName()) && context instanceof ChangeSubscriptionContext) {
                changeSubscriptionContext = (ChangeSubscriptionContext)context;
                ChangeSubscriptionDocument.ChangeSubscription changeSubscription = changeSubscriptionContext.getChangeSubscription();
                Subscription[] subscriptions = changeSubscription.getSubscriptionArray();
                subscriptionChangeList = new SubscriptionChangeList();
                for (int i = 0; i < subscriptions.length; ++i) {
                    SubscriptionChange change = new SubscriptionChange();
                    change.setEvent(subscriptions[i].getEvent().intValue());
                    change.setOperation(subscriptions[i].getSubscriptionState().toString());
                    change.setUser(context.getUsTaskUser() == null ? "" : context.getUsTaskUser().getUserToken());
                    subscriptionChangeList.addSubscriptionChange(change);
                }
            }
        }
        catch (Exception ex) {
            Utils.logException(ex, UsI18NCode.MSG_US_ERROR_GENERATING_TASK_SUBSCRIPTION_CHANGE_LOG_DATA, new Object[0]);
        }
        return subscriptionChangeList;
    }

    private NotificationList generateNotificationLogData(IAbstractContext context) {
        NotificationList notificationList = null;
        Notification notification = null;
        NotificationDetails notificationDetails = null;
        String notificationLogData = null;
        try {
            CreateEmailNotificatonTaskContext createEmailNotificationtaskContext;
            if (context != null && IPFLogOperationsMap.getInstance().doIPFLogging(IPFLogOperationsMap.IPFLogOperation.IPF_LOG_NOTIFICATIONS, context.getOperationName()) && context instanceof CreateEmailNotificatonTaskContext && (notificationDetails = (createEmailNotificationtaskContext = (CreateEmailNotificatonTaskContext)context).getNotificationDetails()) != null) {
                notificationList = new NotificationList();
                notification = new Notification();
                notificationLogData = notificationDetails.getFormattedNotificationDetails(createEmailNotificationtaskContext.getLocale());
                notification.setNotificationDetails(notificationLogData);
                notificationList.addNotification(notification);
            }
        }
        catch (Exception ex) {
            Utils.logException(ex, UsI18NCode.MSG_US_ERROR_GENERATING_TASK_NOTIFICATION_LOG_DATA, new Object[0]);
        }
        return notificationList;
    }

    private String generateTaskCommentLogData(IAbstractContext context) {
        String comment = null;
        try {
            if (context != null && IPFLogOperationsMap.getInstance().doIPFLogging(IPFLogOperationsMap.IPFLogOperation.IPF_LOG_COMMENTS, context.getOperationName()) && context instanceof AddCommentContext) {
                AddCommentContext addCommentContext = (AddCommentContext)context;
                comment = addCommentContext.getText();
            }
        }
        catch (Exception ex) {
            Utils.logException(ex, UsI18NCode.MSG_US_ERROR_GENERATING_TASK_COMMENT_LOG_DATA, new Object[0]);
        }
        return comment;
    }

    private TaskMessageList generateTaskMessageLogData(IAbstractContext context) {
        TaskMessageList taskMessageList = null;
        TaskMessage taskMessage = null;
        HTSTask task = null;
        try {
            List<HTSMessage> hTSMessages;
            if (context != null && (task = context.getPersistedTask()) != null && (hTSMessages = task.getHtsMessages()) != null) {
                taskMessageList = new TaskMessageList();
                for (HTSMessage hTSMessage : hTSMessages) {
                    if (hTSMessage == null) continue;
                    taskMessage = new TaskMessage();
                    taskMessage.setMessage(hTSMessage.getMessage());
                    taskMessage.setMessageType(hTSMessage.getMessageType());
                    taskMessageList.addTaskMessage(taskMessage);
                }
            }
        }
        catch (Exception ex) {
            Utils.logException(ex, UsI18NCode.MSG_US_ERROR_GENERATING_TASK_MESSAGE_LOG_DATA, new Object[0]);
        }
        return taskMessageList;
    }

    public LogAuditAccessIndication getLastIndication() {
        return this.indication;
    }

    public TrackingInfo getTrackingInfo(IAbstractContext context) throws HumanTaskServiceException {
        BiBusHeader header = context.getHeader().getBiBusHeader();
        TrackingInfo info = this.getTrackingInfo(header);
        return info;
    }

    public TrackingInfo getTrackingInfo(BiBusHeader header) throws HumanTaskServiceException {
        Tracking tracking;
        TrackingInfo info = new TrackingInfo();
        if (header != null && (tracking = header.getTracking()) != null) {
            String stepContext;
            String sessionContext;
            String requestContext;
            BigInteger hopCount = tracking.getHopCount();
            if (hopCount != null) {
                info.subrequestId = hopCount.toString();
            }
            info.requestId = requestContext = tracking.getRequestContext();
            info.sessionId = sessionContext = tracking.getSessionContext();
            info.stepId = stepContext = tracking.getStepContext();
        }
        return info;
    }

    private LogTypedLoggerWrapper getLogger(String category) {
        LogTypedLogger logger = null;
        if (m_logger_map.containsKey(category)) {
            logger = m_logger_map.get(category);
        } else {
            logger = LogTypedLogger.getInstance((String)category, LogAuditAccessIndication.class);
            m_logger_map.put(category, logger);
        }
        return new LogTypedLoggerWrapperImpl(logger);
    }

    private class TrackingInfo {
        String stepId = null;
        String sessionId = null;
        String requestId = null;
        String objectPath = null;
        String subrequestId = null;
        String userName = null;

        private TrackingInfo() {
        }
    }
}

