/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.logicalPeopleGroup;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.Headers;
import com.cognos.jsmcommon.util.UserAccountUtil;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class BaseLogicalPeoplegroupSupport {
    protected BiBusHeader header = null;

    public String getDisplayName(String token, Locale locale) throws HumanTaskServiceException {
        String strUserName = "";
        try {
            BaseClass userAccount = this.getBaseClass(token, this.header);
            if (userAccount != null) {
                String strLocalizedName = this.getLocalizedName(locale, userAccount);
                TokenProp defaultName = userAccount.getDefaultName();
                String strDefaultName = "";
                if (defaultName != null) {
                    strDefaultName = defaultName.getValue();
                }
                strUserName = strLocalizedName != null && !strLocalizedName.trim().equals("") ? strLocalizedName : strDefaultName;
            }
        }
        catch (Exception ex) {
            strUserName = I18NUtil.getMessage((I18NCode)I18NCode.KEY_UNKNOWN, (Locale)locale);
        }
        return strUserName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> expandGroup(String group, IAbstractContext context) throws HumanTaskServiceException {
        if (context.getExpandTokens(group) != null) {
            return context.getExpandTokens(group);
        }
        HashSet<String> users = new HashSet<String>();
        ContentManagerServiceClientPort cmPort = null;
        try {
            JobBiBusHeaders headers = new JobBiBusHeaders(this.header);
            cmPort = Client.instance().getContentManagerServiceClient(headers);
            String search = "expandDistributionMembers(" + group + ")";
            SearchPathMultipleObject spmo = new SearchPathMultipleObject(search);
            PropEnum[] props = new PropEnum[]{PropEnum.searchPath};
            cmPort.signNextRequest("DLS");
            BaseClass[] replies = cmPort.query(spmo, props, new Sort[0], new QueryOptions());
            for (int i = 0; i < replies.length; ++i) {
                if (!(replies[i] instanceof Account)) continue;
                users.add(((Account)replies[i]).getSearchPath().getValue());
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_US_INVALID_CAM_ID);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        context.setExpandTokens(group, users);
        return users;
    }

    protected String getLocalizedName(Locale locale, BaseClass userAccount) {
        String strLocalizedName = "";
        if (locale != null) {
            MultilingualToken[] multilingualTokensList;
            MultilingualTokenProp multilingualTokenProp = userAccount.getName();
            for (MultilingualToken token : multilingualTokensList = multilingualTokenProp.getValue()) {
                if (token.getLocale() == null || !locale.getLanguage().equals(new Locale(token.getLocale(), "", "").getLanguage())) continue;
                strLocalizedName = token.getValue();
                break;
            }
        }
        return strLocalizedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseClass getBaseClass(String searchPath, BiBusHeader biBusHeader) throws SDKClientException, EMFSecurityException {
        BaseClass acc = null;
        if (searchPath != null && !searchPath.trim().equals("")) {
            JobBiBusHeaders headers = new JobBiBusHeaders(biBusHeader);
            ContentManagerServiceClientPort cm = Client.instance().getContentManagerServiceClient(headers);
            try {
                cm.signNextRequest("JSM");
                BaseClass[] queryResult = cm.query(searchPath, new PropEnum[]{PropEnum.defaultName, PropEnum.name}, new Sort[0], new QueryOptions());
                if (queryResult[0] instanceof BaseClass) {
                    acc = queryResult[0];
                }
            }
            finally {
                if (cm != null) {
                    cm.close();
                }
            }
        }
        return acc;
    }

    public UserAccountUtil getUserAccountUtil(Headers header) throws HumanTaskServiceException {
        UserAccountUtil util = null;
        try {
            util = new UserAccountUtil(new JobBiBusHeaders(header.getBiBusHeader()), true);
        }
        catch (SDKClientException e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_USER_DATA, e);
        }
        catch (EMFSecurityException e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_USER_DATA, e);
        }
        return util;
    }

    public DeliveryOptionEnum getAddressStyle(DeliveryOptionEnum addressStyle) throws Exception {
        return addressStyle;
    }
}

