/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.logicalPeopleGroup;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Group;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.Role;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.exports.fixup.CMTaskUserFixupStrategy;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.BaseLogicalPeoplegroupSupport;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupport;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class CamLogicalPeopleGroupSupport
extends BaseLogicalPeoplegroupSupport
implements LogicalPeopleGroupSupport {
    @Override
    public LogicalPeopleGroupSupport initialize(Object ... arguments) {
        this.header = (BiBusHeader)arguments[0];
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getGroups(String token, IAbstractContext context) throws HumanTaskServiceException {
        if (context.getGroupsForToken(token) != null) {
            return context.getGroupsForToken(token);
        }
        ContentManagerServiceClientPort cm = null;
        HashSet<String> userRolesAndGroupsList = null;
        try {
            userRolesAndGroupsList = new HashSet<String>();
            JobBiBusHeaders headers = new JobBiBusHeaders(this.header);
            cm = Client.instance().getContentManagerServiceClient(headers);
            BaseClass[] queryResult = cm.query("~~", new PropEnum[]{PropEnum.identity}, new Sort[0], new QueryOptions());
            if (queryResult[0] instanceof Session) {
                BaseClass[] classes;
                Session userSession = (Session)queryResult[0];
                for (BaseClass baseClass : classes = userSession.getIdentity().getValue()) {
                    String strValue;
                    if (!(baseClass instanceof Role) && !(baseClass instanceof Group) || (strValue = baseClass.getSearchPath().getValue()) == null || strValue.trim().equals("")) continue;
                    userRolesAndGroupsList.add(strValue);
                }
            }
        }
        catch (Exception ex) {
            Utils.throwHumanTaskServiceException(ex, UsI18NCode.MSG_US_INVALID_CAM_ID);
        }
        finally {
            if (cm != null) {
                cm.close();
            }
        }
        context.setGroupsForToken(token, userRolesAndGroupsList);
        return userRolesAndGroupsList;
    }

    @Override
    public void collectFixupData(Set<String> collector, CMTaskUserFixupStrategy taskUserFixupStrategy) throws Exception {
    }

    @Override
    public void writeFixup(DeploymentResources resources, Writer writer, CMTaskUserFixupStrategy taskUserFixupStrategy) throws Exception {
    }
}

