/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.logicalPeopleGroup;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.Permission;
import com.cognos.developer.schemas.bibus._3.Policy;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.deployment.DeploymentResources;
import com.ibm.cognos.internal.hts.deployment.exports.fixup.CMTaskUserFixupStrategy;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.BaseLogicalPeoplegroupSupport;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupport;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class ContentManagerLogicalPeopleGroupSupport
extends BaseLogicalPeoplegroupSupport
implements LogicalPeopleGroupSupport {
    @Override
    public ContentManagerLogicalPeopleGroupSupport initialize(Object ... arguments) {
        this.header = (BiBusHeader)arguments[0];
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> expandGroup(String group, IAbstractContext context) throws HumanTaskServiceException {
        HashSet<String> users = new HashSet<String>();
        ContentManagerServiceClientPort cmPort = null;
        try {
            JobBiBusHeaders headers = new JobBiBusHeaders(this.header);
            cmPort = Client.instance().getContentManagerServiceClient(headers);
            QueryRequest request = new QueryRequest();
            request.setSearch(ObjectModelUtil.getSearchPath((Guid)new Guid(group)).get_value());
            request.setProperties(new PropEnum[]{PropEnum.policies});
            cmPort.signNextRequest("DLS");
            BaseClass reply = cmPort.query(request);
            if (reply != null) {
                Policy[] policies = reply.getPolicies().getValue();
                for (int i = 0; i < policies.length; ++i) {
                    if (!this.checkRead(policies[i])) continue;
                    BaseClass base = policies[i].getSecurityObject();
                    users.addAll(super.expandGroup(ObjectModelUtil.getSearchPath((BaseClass)base), context));
                }
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_US_INVALID_CAM_ID);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return users;
    }

    private boolean checkRead(Policy policy) {
        boolean canRead = false;
        Permission[] perms = policy.getPermissions();
        for (int i = 0; !canRead && i < perms.length; ++i) {
            canRead = "read".equals(perms[i].getName());
            canRead = canRead && "grant".equals(perms[i].getAccess());
        }
        return canRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getGroups(String token, IAbstractContext context) throws HumanTaskServiceException {
        if (context.getGroupsForToken(token) != null) {
            return context.getGroupsForToken(token);
        }
        ContentManagerServiceClientPort cm = null;
        HashSet<String> groups = new HashSet<String>();
        try {
            cm = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(this.header));
            BaseClass[] queryResult = cm.query(ObjectModelUtil.getSearchPath((Guid)new Guid(token)).get_value(), new PropEnum[]{PropEnum.searchPath, PropEnum.permissions}, new Sort[0], new QueryOptions());
            if (queryResult != null && queryResult.length == 1 && AuthenticatorFactory.getInstance().hasPermission(queryResult[0], "read")) {
                groups.add(token);
            }
        }
        catch (Exception ex) {
            Utils.throwHumanTaskServiceException(ex, UsI18NCode.MSG_US_INVALID_CAM_ID);
        }
        finally {
            if (cm != null) {
                cm.close();
            }
        }
        context.setGroupsForToken(token, groups);
        return groups;
    }

    @Override
    protected BaseClass getBaseClass(String camId, BiBusHeader biBusHeader) throws SDKClientException, EMFSecurityException {
        String searchPath = ObjectModelUtil.getSearchPathFromGuid((String)camId).get_value();
        return super.getBaseClass(searchPath, biBusHeader);
    }

    @Override
    public void collectFixupData(Set<String> collector, CMTaskUserFixupStrategy taskUserFixupStrategy) throws Exception {
        collector.add(taskUserFixupStrategy.getTaskUser().getUserToken());
    }

    @Override
    public void writeFixup(DeploymentResources resources, Writer writer, CMTaskUserFixupStrategy taskUserFixupStrategy) throws Exception {
        HTSTaskUser htsTaskUser = taskUserFixupStrategy.getTaskUser();
        taskUserFixupStrategy.startFixups(writer);
        taskUserFixupStrategy.writeFixup(resources, writer, htsTaskUser.getUserToken(), taskUserFixupStrategy.getSearchpath(resources, htsTaskUser.getUserToken()));
        taskUserFixupStrategy.endFixups(writer);
    }
}

