/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.logicalPeopleGroup;

import com.cognos.jsmcommon.util.Filter;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupport;
import com.ibm.cognos.internal.hts.properties.HTSServerProperties;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.HashMap;
import java.util.Map;

public class LogicalPeopleGroupSupportFactory {
    public static final String LOGICAL_PEOPLE_GROUP_PROPERTY_PREFIX = "logicalPeopleGroupSupport.";
    private static LogicalPeopleGroupSupportFactory factory = new LogicalPeopleGroupSupportFactory();
    private Map<String, String> lpgaProps = new HashMap<String, String>();
    private String defaultLogicalPeopleGroup = "CAM";

    public static LogicalPeopleGroupSupportFactory getInstance() {
        return factory;
    }

    public void setDefaultLogicalPeopleGroup(String defaultValue) {
        this.defaultLogicalPeopleGroup = defaultValue;
    }

    public String getDefaultLogicalPeopleGroup() {
        return this.defaultLogicalPeopleGroup;
    }

    public LogicalPeopleGroupSupport getDefaultLogicalPeopleGroupSupport() throws HumanTaskServiceException {
        return this.getLogicalPeopleGroupSupport(this.defaultLogicalPeopleGroup);
    }

    public LogicalPeopleGroupSupport getLogicalPeopleGroupSupport(String peopleGroupName) throws HumanTaskServiceException {
        LogicalPeopleGroupSupport support = null;
        try {
            if (this.lpgaProps.containsKey(LOGICAL_PEOPLE_GROUP_PROPERTY_PREFIX + peopleGroupName)) {
                String clazzName = this.lpgaProps.get(LOGICAL_PEOPLE_GROUP_PROPERTY_PREFIX + peopleGroupName);
                support = (LogicalPeopleGroupSupport)Class.forName(clazzName).newInstance();
            }
        }
        catch (Exception e) {
            Utils.logException(e);
            Utils.throwHumanTaskServiceException(e);
        }
        return support;
    }

    public String getLogicalPeopleGroupSupportClass(String peopleGroupName) throws HumanTaskServiceException {
        String className = null;
        try {
            if (this.lpgaProps.containsKey(LOGICAL_PEOPLE_GROUP_PROPERTY_PREFIX + peopleGroupName)) {
                className = this.lpgaProps.get(LOGICAL_PEOPLE_GROUP_PROPERTY_PREFIX + peopleGroupName);
            }
        }
        catch (Exception e) {
            Utils.logException(e);
            Utils.throwHumanTaskServiceException(e);
        }
        return className;
    }

    public void setLogicalPeopleGroupSupport(String lpgName, String clazz) {
        this.lpgaProps.put(LOGICAL_PEOPLE_GROUP_PROPERTY_PREFIX + lpgName, clazz);
    }

    private LogicalPeopleGroupSupportFactory() {
        this.readProperties();
    }

    public void readProperties() {
        Map<String, String> propertiesFromFile = HTSServerProperties.getInstance().getProperties(new Filter(){

            public boolean accept(Object object) {
                Map.Entry entry = (Map.Entry)object;
                return entry != null && entry.getKey().toString().startsWith(LogicalPeopleGroupSupportFactory.LOGICAL_PEOPLE_GROUP_PROPERTY_PREFIX) && entry.getValue() != null && !entry.getValue().toString().equals("");
            }
        });
        this.lpgaProps.putAll(propertiesFromFile);
    }
}

