/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.notification;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.ArrayList;
import java.util.Locale;

public class NotificationDetails {
    private String mailSender = null;
    private String subject = null;
    private String msgBodyPlain = null;
    private String msgBodyHTML = null;
    private ArrayList<String> recipientsList = null;

    public NotificationDetails() {
    }

    public NotificationDetails(String mailSender, String subject, String msgBodyPlain, String msgBodyHTML, ArrayList<String> recipientsList) {
        this.mailSender = mailSender;
        this.msgBodyHTML = msgBodyHTML;
        this.msgBodyPlain = msgBodyPlain;
        this.recipientsList = recipientsList;
        this.subject = subject;
    }

    public String getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(String mailSender) {
        this.mailSender = mailSender;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMsgBodyPlain() {
        return this.msgBodyPlain;
    }

    public void setMsgBodyPlain(String msgBodyPlain) {
        this.msgBodyPlain = msgBodyPlain;
    }

    public String getMsgBodyHTML() {
        return this.msgBodyHTML;
    }

    public void setMsgBodyHTML(String msgBodyHTML) {
        this.msgBodyHTML = msgBodyHTML;
    }

    public ArrayList<String> getRecipientsList() {
        return this.recipientsList;
    }

    public void setRecipientsList(ArrayList<String> recipientsList) {
        this.recipientsList = recipientsList;
    }

    public String getFormattedNotificationDetails(Locale locale) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_USV_NOTIFICATION_RECIPIENTS, (Locale)locale));
            sb.append(" ");
            if (this.recipientsList != null) {
                int count = 0;
                for (String recipient : this.recipientsList) {
                    if (recipient == null) continue;
                    if (count > 0) {
                        sb.append(", ");
                    }
                    sb.append(recipient);
                    ++count;
                }
            }
            sb.append("\n");
            sb.append(I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_USV_NOTIFICATION_SUBJECT, (Locale)locale));
            sb.append(" ");
            sb.append(this.subject == null ? "" : this.subject);
            sb.append("\n");
            sb.append(I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_USV_NOTIFICATION_MESSAGE_BODY_PLAIN, (Locale)locale));
            sb.append(" ");
            sb.append(this.msgBodyPlain == null ? "" : this.msgBodyPlain);
            sb.append("\n");
            sb.append(I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_USV_NOTIFICATION_MESSAGE_BODY_HTML, (Locale)locale));
            sb.append(" ");
            sb.append(this.msgBodyHTML == null ? "" : this.msgBodyHTML);
            sb.append("\n");
        }
        catch (Exception ex) {
            Utils.logException(ex);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        NotificationDetails nd = new NotificationDetails();
        nd.mailSender = "Test Mail Sender";
        nd.msgBodyPlain = "Test Message Body";
        nd.msgBodyHTML = "Test personalised message body";
        nd.subject = "Test personalised subject";
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add("test@test.com");
        recipients.add("test1@test.com");
        recipients.add("test2@test.com");
        nd.recipientsList = recipients;
    }
}

