/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.openjpa;

import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.GenericDAO;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.FetchMode;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;

public abstract class AbstractOpenJPADAO<T, ID extends Serializable>
implements GenericDAO<T, ID> {
    private Class<T> persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public EntityManager getEntityManager() {
        return AbstractContext.getCurrentTransactionHandler().getEntityManager();
    }

    @Override
    public T findById(String id, String[] fetchgroups, FetchMode fetchMode) {
        String name = this.getPersistentClass().getName();
        Query query = this.getEntityManager().createQuery("select a from " + name + " a where a.id = :ID");
        query.setParameter("ID", (Object)id);
        OpenJPAQuery kq = OpenJPAPersistence.cast((Query)query);
        JDBCFetchPlan fetch = (JDBCFetchPlan)kq.getFetchPlan();
        for (int i = 0; i < fetchgroups.length; ++i) {
            fetch.addFetchGroup(fetchgroups[i]);
        }
        fetch.setEagerFetchMode(fetchMode);
        return (T)query.getSingleResult();
    }

    @Override
    public void save(T entity) {
        this.getEntityManager().persist(entity);
    }

    @Override
    public void saveOrUpdate(T entity) {
        this.getEntityManager().merge(entity);
    }

    @Override
    public T update(T entity) {
        return (T)this.getEntityManager().merge(entity);
    }

    @Override
    public void delete(T entity) {
        this.getEntityManager().remove(entity);
    }

    @Override
    public boolean isDetached(T entity) {
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)this.getEntityManager());
        return kem.isDetached(entity);
    }

    @Override
    public Object merge(T entity) {
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)this.getEntityManager());
        return kem.merge(entity);
    }

    @Override
    public void delete(T entity, Boolean doItNow) {
        if (doItNow.booleanValue()) {
            this.getEntityManager().setFlushMode(FlushModeType.AUTO);
        }
        this.delete(entity);
    }

    @Override
    public void refresh(T entity) {
        this.getEntityManager().refresh(entity);
    }

    protected List<T> find(String queryString) {
        Query query = this.getEntityManager().createQuery(queryString);
        return query.getResultList();
    }

    public T loadById(ID id) {
        return (T)this.getEntityManager().find(this.getPersistentClass(), id);
    }

    public Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public T getById(ID id) {
        return (T)this.getEntityManager().find(this.getPersistentClass(), id);
    }

    @Override
    public T getById(ID id, boolean lock) {
        if (lock) {
            return (T)this.getEntityManager().find(this.getPersistentClass(), id);
        }
        return this.getById(id);
    }

    @Override
    public int deleteById(ID id) {
        this.getEntityManager().remove(this.loadById(id));
        return 1;
    }

    @Override
    public List<T> findAll() {
        String name = this.getPersistentClass().getName();
        Query query = this.getEntityManager().createQuery("select a from " + name + " a");
        return query.getResultList();
    }

    protected String getSchema() {
        Object schemaObj = OpenJPAUtil.getConfigProperties().get("openjpa.jdbc.Schema");
        return schemaObj == null ? "" : schemaObj.toString() + ".";
    }
}

