/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.openjpa;

import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.OrderByClause;
import com.ibm.cognos.internal.hts.persist.dao.TaskSearchProperties;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;

public class GetTasksOrderByClause
implements OrderByClause {
    private TaskSearchProperties _properties;
    private String _orderColumn = null;
    private String _direction = null;

    public GetTasksOrderByClause(TaskSearchProperties searchProperties) {
        this._properties = searchProperties;
    }

    @Override
    public void parseOrderByClause(String orderByClause) throws HumanTaskServiceException {
        if (orderByClause == null || orderByClause.length() == 0) {
            return;
        }
        int index = orderByClause.indexOf(" ");
        index = index == -1 ? orderByClause.length() : index;
        String column = orderByClause.substring(0, index);
        String direction = "";
        if (index < orderByClause.length()) {
            direction = orderByClause.substring(index + 1);
        }
        this.setOrderByColumn(column.trim());
        this.setDirection(direction);
    }

    @Override
    public String getClause() {
        StringBuffer buffer = new StringBuffer();
        if (this._orderColumn != null && this._orderColumn.length() > 0) {
            buffer.append("ORDER BY ");
            buffer.append(this._properties.getSearchValue(this._orderColumn));
            if (this._direction != null && this._direction.length() > 0) {
                buffer.append(" ").append(this._direction);
            }
        }
        return buffer.toString();
    }

    private void setDirection(String direction) throws HumanTaskServiceException {
        String valid = "";
        if ("asc".equalsIgnoreCase(direction) || "ascending".equalsIgnoreCase(direction)) {
            valid = "asc";
        } else if ("desc".equalsIgnoreCase(direction) || "descending".equalsIgnoreCase(direction)) {
            valid = "desc";
        } else if (direction != null && direction.length() > 0) {
            Utils.debug("Invalid sort direction for order by clause [" + direction + "]");
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_ORDER_BY);
        }
        this._direction = valid;
    }

    private void setOrderByColumn(String column) throws HumanTaskServiceException {
        String dbColumn = this._properties.getSearchValue(column);
        if (dbColumn == null || dbColumn.length() <= 0) {
            Utils.debug("No mapping found in oreder by clause criteria for property [" + column + "]");
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_ORDER_BY);
        }
        this._orderColumn = column;
    }
}

