/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.openjpa;

import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.SelectClause;
import com.ibm.cognos.internal.hts.persist.dao.TaskSearchProperties;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class GetTasksSelectClause
implements SelectClause<HTSTask> {
    private TaskSearchProperties _properties;
    private static final String COMMA = ",";
    private List<String> _columns = new ArrayList<String>();
    private List<String> _mapColumn = new ArrayList<String>();

    public GetTasksSelectClause(TaskSearchProperties searchProperties) {
        this._properties = searchProperties;
    }

    @Override
    public void parseSelectClause(String selectClause) throws HumanTaskServiceException {
        if (selectClause == null || selectClause.length() == 0 || "*".equals(selectClause)) {
            return;
        }
        int index = selectClause.indexOf(COMMA);
        if (index == -1) {
            this.addColumn(selectClause.trim());
        } else {
            String col;
            int current = 0;
            do {
                col = selectClause.substring(current, index);
                this.addColumn(col.trim());
            } while ((index = selectClause.indexOf(COMMA, current = index + COMMA.length())) != -1);
            if (current < selectClause.length()) {
                col = selectClause.substring(current);
                this.addColumn(col.trim());
            }
        }
    }

    @Override
    public String getClause() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT DISTINCT");
        boolean first = true;
        for (String column : this._columns) {
            if (!first) {
                buffer.append(COMMA);
            }
            buffer.append(" ").append(column);
            first = false;
        }
        if (first) {
            buffer.append(" ").append(this._properties.getSearchValue("Task"));
        }
        return buffer.toString();
    }

    private void addColumn(String column) throws HumanTaskServiceException {
        String dbColumn = this._properties.getSearchValue(column);
        if (dbColumn == null || dbColumn.length() <= 0) {
            Utils.debug("No mapping found in select clause criteria for property [" + column + "]");
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_SELECT);
        }
        this._columns.add(dbColumn);
        this._mapColumn.add(column);
    }

    @Override
    public List<HTSTask> buildResultObjects(List<?> resultSet) {
        if (this._columns.isEmpty()) {
            return resultSet;
        }
        ArrayList<HTSTask> tasks = new ArrayList<HTSTask>(resultSet.size());
        for (int i = 0; i < resultSet.size(); ++i) {
            tasks.add(new HTSTask());
        }
        int column = 0;
        for (String mapping : this._mapColumn) {
            int taskIndex = 0;
            for (HTSTask result : resultSet) {
                if (result instanceof Object[]) {
                    Object[] row = (Object[])result;
                    Object value = row[column];
                    HTSTask task = (HTSTask)tasks.get(taskIndex);
                    this.setTaskValue(task, mapping, value);
                }
                ++taskIndex;
            }
            ++column;
        }
        return tasks;
    }

    private void setTaskValue(HTSTask task, String mapping, Object value) {
        if ("Task.ID".equals(mapping)) {
            task.setId((String)value);
        } else if ("Task.Name".equals(mapping)) {
            task.setName((String)value);
        } else if ("Task.Status".equals(mapping)) {
            task.setStatus((String)value);
        } else if ("Task.Priority".equals(mapping)) {
            task.setPriority((Integer)value);
        } else if ("Task.CreateDate".equals(mapping)) {
            task.setCreatedOn((Long)value);
        } else if ("Task.ActivationTime".equals(mapping)) {
            task.setActivationTime((Long)value);
        } else if ("Task.ExpirationTime".equals(mapping)) {
            task.setExpirationTime((Long)value);
        } else if ("Task.CreatedBy".equals(mapping)) {
            task.setCreatedBy((HTSTaskUser)value);
        } else if ("Task.TaskInitiator".equals(mapping)) {
            task.setTaskInitiator((HTSTaskUser)value);
        } else if ("Task.ActualOwner".equals(mapping)) {
            task.setActualOwner((HTSTaskUser)value);
        } else if ("Task.taskClassVersion".equals(mapping)) {
            task.setTaskClassVersion((String)value);
        } else if ("Task.operation".equals(mapping)) {
            task.setOperation((String)value);
        }
    }
}

