/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.openjpa;

import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.TaskSearchProperties;
import com.ibm.cognos.internal.hts.persist.dao.WhereClause;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.StringUtil;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.ParamNameValue;
import com.ibm.cognos.internal.hts.util.dao.WhereClauseParseException;
import com.ibm.cognos.internal.hts.util.dao.WhereClausePiece;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.Query;

public class GetTasksWhereClause
implements WhereClause {
    private static final int PARAM_START = 0;
    private static final String AND_LC = " and";
    private static final String AND_UC = " AND";
    private TaskSearchProperties _properties;
    private String[] m_markers;
    private String[] m_substitutions;
    private List<WhereClausePiece> m_whereClauses = new ArrayList<WhereClausePiece>();

    public GetTasksWhereClause(TaskSearchProperties searchProperties) {
        this._properties = searchProperties;
    }

    @Override
    public boolean valuesContain(Object value) {
        WhereClausePiece pnv;
        if (value == null) {
            return false;
        }
        boolean contains = false;
        Iterator<WhereClausePiece> iterator = this.m_whereClauses.iterator();
        while (iterator.hasNext() && !(contains = (pnv = iterator.next()).containsValue(value))) {
        }
        return contains;
    }

    @Override
    public List<WhereClausePiece> getClauses() {
        return this.m_whereClauses;
    }

    @Override
    public boolean remove(WhereClausePiece pnv) {
        return this.m_whereClauses.remove(pnv);
    }

    @Override
    public String getClause() {
        StringBuffer buffer = new StringBuffer();
        if (this.m_whereClauses.size() > 0) {
            buffer.append("WHERE ");
            int counter = 0;
            int pieceIndex = 0;
            for (WhereClausePiece pnv : this.m_whereClauses) {
                counter = pnv.appendWhereCaluse(buffer, counter);
                if (++pieceIndex >= this.m_whereClauses.size()) continue;
                buffer.append(" AND ");
            }
        }
        return buffer.toString();
    }

    @Override
    public void addWhereClause(String property, String operator, Object value) {
        WhereClausePiece pnv = ParamNameValue.makeParamNameValue(this._properties.getSearchValue(property), operator, value);
        this.m_whereClauses.add(pnv);
    }

    @Override
    public void parseWhereClause(String whereClause) throws HumanTaskServiceException {
        this.parseWhereClause(whereClause, new String[0], new String[0]);
    }

    @Override
    public void parseWhereClause(String whereClause, String[] markers, String[] substitutions) throws HumanTaskServiceException {
        if (whereClause == null || whereClause.length() == 0) {
            return;
        }
        if (markers == null || substitutions == null || markers.length != substitutions.length) {
            throw new WhereClauseParseException(UsI18NCode.MSG_US_INVALID_WHERE);
        }
        this.m_markers = markers;
        this.m_substitutions = substitutions;
        Iterator<String> pairs = this.split(whereClause);
        while (pairs.hasNext()) {
            String clause = pairs.next();
            this.parse(clause);
        }
    }

    @Override
    public void setParameterValues(Query query) {
        int counter = 0;
        for (WhereClausePiece pnv : this.m_whereClauses) {
            counter = pnv.setParameter(query, counter);
        }
    }

    public static String encodeWhereClauseToken(String token) throws HumanTaskServiceException {
        try {
            token = URLEncoder.encode(token, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Utils.throwHumanTaskServiceException(e);
        }
        return token;
    }

    public static String decodeWhereClauseToken(String token) throws HumanTaskServiceException {
        try {
            token = URLDecoder.decode(token, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Utils.throwHumanTaskServiceException(e);
        }
        return token;
    }

    private void parse(String whereClause) throws WhereClauseParseException, HumanTaskServiceException {
        String lhs = null;
        String rhs = null;
        String operator = this.findOperator(whereClause);
        String dbCol = "";
        Object paramValue = null;
        if (!this.isValidWhereClause(whereClause, operator)) {
            throw new WhereClauseParseException(UsI18NCode.MSG_US_INVALID_WHERE, new Object[]{whereClause});
        }
        if (operator.equalsIgnoreCase("IN")) {
            lhs = this.doSubstitutions(GetTasksWhereClause.decodeWhereClauseToken(whereClause.substring(0, whereClause.indexOf(operator) - 1)));
            rhs = this.doSubstitutions(GetTasksWhereClause.decodeWhereClauseToken(whereClause.substring(whereClause.indexOf(operator) + operator.length() + 1, whereClause.length())));
            dbCol = this._properties.getSearchValue(lhs);
            paramValue = this._properties.makeObjectValue(lhs, rhs);
            paramValue = paramValue.toString().replaceFirst("\\(", "");
            paramValue = paramValue.toString().replaceFirst("\\)", "");
        } else {
            StringTokenizer st = new StringTokenizer(whereClause, operator);
            if (st == null || st.countTokens() != 2) {
                throw new WhereClauseParseException(UsI18NCode.MSG_US_INVALID_WHERE, new Object[]{whereClause});
            }
            for (int i = 0; i < 2; ++i) {
                String token = st.nextToken();
                if (this.isValidWhereClause(token)) {
                    throw new WhereClauseParseException(UsI18NCode.MSG_US_INVALID_WHERE, new Object[]{whereClause});
                }
                if (i == 0) {
                    lhs = this.doSubstitutions(GetTasksWhereClause.decodeWhereClauseToken(token.trim()));
                }
                if (i != 1) continue;
                rhs = this.doSubstitutions(GetTasksWhereClause.decodeWhereClauseToken(token.trim()));
            }
            dbCol = this._properties.getSearchValue(lhs);
            paramValue = this._properties.makeObjectValue(lhs, rhs);
        }
        if (dbCol != null && dbCol.length() > 0 && paramValue != null) {
            WhereClausePiece pnv = ParamNameValue.makeParamNameValue(dbCol, operator, paramValue);
            this.m_whereClauses.add(pnv);
        }
    }

    private String doSubstitutions(String target) {
        if (this.m_markers == null || target == null) {
            return target;
        }
        for (int i = 0; i < this.m_markers.length; ++i) {
            if (this.m_markers[i] == null || this.m_substitutions[i] == null) continue;
            target = target.replace(this.m_markers[i], this.m_substitutions[i]);
        }
        return target;
    }

    private Iterator<String> split(String whereClause) {
        ArrayList<String> items = new ArrayList<String>();
        whereClause = whereClause.replaceAll(AND_LC, AND_UC);
        int pos = whereClause.indexOf(AND_UC);
        int current = 0;
        if (pos == -1) {
            items.add(whereClause);
        } else {
            do {
                this.addItem(whereClause.substring(current, pos), items);
            } while ((pos = whereClause.indexOf(AND_UC, current = pos + AND_UC.length())) != -1);
            if (current <= whereClause.length()) {
                this.addItem(whereClause.substring(current, whereClause.length()), items);
            }
        }
        return items.iterator();
    }

    private void addItem(String item, List<String> items) {
        item = StringUtil.trim(item);
        items.add(item);
    }

    private String findOperator(String whereClause) {
        String operator = null;
        if (whereClause.indexOf("<>") != -1) {
            operator = "<>";
        } else if (whereClause.indexOf("<=") != -1) {
            operator = "<=";
        } else if (whereClause.indexOf(">=") != -1) {
            operator = ">=";
        } else if (whereClause.indexOf("=") != -1) {
            operator = "=";
        } else if (whereClause.indexOf("<") != -1) {
            operator = "<";
        } else if (whereClause.indexOf(">") != -1) {
            operator = ">";
        } else if (whereClause.indexOf("IN(") != -1 || whereClause.indexOf("IN (") != -1) {
            operator = "IN";
        }
        return operator;
    }

    private boolean isValidWhereClause(String whereClause) {
        return this.isValidWhereClause(whereClause, this.findOperator(whereClause));
    }

    private boolean isValidWhereClause(String whereClause, String operator) {
        return whereClause.toUpperCase().indexOf(" OR ") == -1 && whereClause.toUpperCase().indexOf(" IS ") == -1 && operator != null;
    }
}

