/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.openjpa;

import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.PersistenceUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;

public class JPAPersistenceUtil
implements PersistenceUtil {
    private PersistenceUnit persistenceUnit;
    private ITransactionHandler pUtil;

    public JPAPersistenceUtil(PersistenceUnit pu, ITransactionHandler trx) {
        this.pUtil = trx;
        this.persistenceUnit = pu;
        EntityManagerFactoryImpl emFactory = (EntityManagerFactoryImpl)OpenJPAUtil.getNamedEntityManagerFactory(pu);
        JDBCConfiguration config = (JDBCConfiguration)emFactory.getConfiguration();
        Collection persistentClasses = config.getMappingRepositoryInstance().loadPersistentTypes(true, this.getClass().getClassLoader());
        if (persistentClasses != null && !persistentClasses.isEmpty()) {
            Iterator it = persistentClasses.iterator();
            while (it.hasNext()) {
                config.getMetaDataRepositoryInstance().getMetaData((Class)it.next(), this.getClass().getClassLoader(), false);
            }
        }
    }

    public JPAPersistenceUtil(PersistenceUnit pu) {
        this(pu, new OpenJPAUtil(pu));
    }

    public EntityManager getEntityManager() {
        return this.pUtil.getEntityManager();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return OpenJPAUtil.getNamedEntityManagerFactory(this.persistenceUnit);
    }

    @Override
    public EntityTransaction getTransaction() {
        return this.getEntityManager().getTransaction();
    }

    @Override
    public void save(Object entity) {
        this.getEntityManager().persist(entity);
    }

    @Override
    public int deleteAll(Class clazz) {
        String name = clazz.getName();
        Query query = this.getEntityManager().createQuery("delete from " + name);
        return query.executeUpdate();
    }

    @Override
    public void saveOrUpdate(Object entity) {
        this.getEntityManager().merge(entity);
    }

    @Override
    public Object update(Object entity) {
        return this.getEntityManager().merge(entity);
    }

    @Override
    public void delete(Object entity) {
        this.getEntityManager().remove(entity);
    }

    @Override
    public void delete(Object entity, Boolean doItNow) {
        if (doItNow.booleanValue()) {
            this.getEntityManager().setFlushMode(FlushModeType.AUTO);
        }
        this.delete(entity);
    }

    @Override
    public List<Object> find(String queryString) {
        Query query = this.getEntityManager().createQuery(queryString);
        return query.getResultList();
    }

    @Override
    public Object loadById(Class clazz, String id) {
        return this.getEntityManager().find(clazz, (Object)id);
    }

    public List<Object> findByIds(Class clazz, Object ids) {
        String name = clazz.getName();
        Query query = this.getEntityManager().createQuery("select a from " + name + " a where a.id in(:ids)");
        query.setParameter(":ids", ids);
        return query.getResultList();
    }

    @Override
    public int deleteById(Class clazz, String id) {
        this.getEntityManager().remove(this.loadById(clazz, id));
        return 1;
    }

    @Override
    public List<Object> findAll(Class clazz) {
        String name = clazz.getName();
        Query query = this.getEntityManager().createQuery("select a from " + name + " a");
        return query.getResultList();
    }

    @Override
    public void close() {
        this.pUtil.closeSession();
    }

    protected String setUserTokenParameterList(List<String> userTokens) {
        StringBuffer buf = new StringBuffer("taskuser.userToken IN (");
        for (int i = 0; i < userTokens.size(); ++i) {
            buf.append("'");
            buf.append(userTokens.get(i));
            buf.append("'");
            if (i + 1 >= userTokens.size()) continue;
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }
}

