/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.openjpa;

import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jdbc.props.ServerPropsFactory;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.util.Filter;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.SchemaConfigurationPlugin;
import com.ibm.cognos.internal.hts.persist.jdbc.HTSCMProperties;
import com.ibm.cognos.internal.hts.properties.HTSProperties;
import com.ibm.cognos.internal.hts.properties.HTSServerProperties;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.sql.DataSource;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public final class OpenJPAUtil
implements ITransactionHandler {
    private static PersistenceUnit DEFAULT = PersistenceUnit.HUMANTASK_SERVICE;
    private static final String JPA_CONNECTION_FACTORY = "openjpa.ConnectionFactory";
    private static final String JPA_DB_DICT_PROPS = "openjpa.jdbc.DBDictionary";
    private static final String JPA_ORACLE_BATCHING_VALUE = "batchLimit=0";
    private static final String JPA_PERSISTENCE_XML = "openjpa.persistence.xml";
    private static final String DB_TYPE = "test.dbType";
    private static final Map<String, Object> configMap = new HashMap<String, Object>();
    private static final Map<PersistenceUnit, EntityManagerFactory> emfs = new HashMap<PersistenceUnit, EntityManagerFactory>();
    private static JDBCConnectionProperties props;
    private static boolean initialized;
    private PersistenceUnit persistenceUnit;
    private EntityManager m_session;
    private EntityTransaction m_transaction;

    public static Map<String, Object> getConfigProperties() {
        return configMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initialise() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            HTSProperties usProps = HTSServerProperties.getInstance();
            configMap.putAll(usProps.getProperties(new Filter(){

                public boolean accept(Object object) {
                    Map.Entry entry = (Map.Entry)object;
                    return entry != null && entry.getKey().toString().startsWith("openjpa.") && entry.getValue() != null && !entry.getValue().toString().equals("");
                }
            }));
            String testDbType = usProps.getProperty(DB_TYPE);
            if (testDbType == null) {
                try {
                    props = JDBCConnectionProperties.instance((String)"HTS");
                }
                catch (Throwable throwable) {}
            } else {
                props = new ServerPropsFactory().getProperties((CMProperties)new HTSCMProperties(usProps), testDbType);
                JDBCConnectionProperties.setInstance((JDBCConnectionProperties)props, (String)"HTS");
            }
            if (usProps.getProperty(JPA_CONNECTION_FACTORY) != null) {
                Class<?> connClass = Class.forName(usProps.getProperty(JPA_CONNECTION_FACTORY));
                DataSource ds = (DataSource)connClass.newInstance();
                configMap.put(JPA_CONNECTION_FACTORY, ds);
                String schema = usProps.getProperty("openjpa.jdbc.Schema");
                if (schema == null || schema.equals("")) {
                    SchemaConfigurationPlugin plugin = new SchemaConfigurationPlugin();
                    Connection connection = ds.getConnection();
                    try {
                        plugin.configure(configMap, connection);
                    }
                    finally {
                        connection.close();
                    }
                } else {
                    configMap.put("openjpa.jdbc.Schema", schema);
                }
            }
            if (DatabaseType.ORACLE.toString().equals(testDbType) || props != null && props.getDBType().equals((Object)DatabaseType.ORACLE)) {
                configMap.put(JPA_DB_DICT_PROPS, JPA_ORACLE_BATCHING_VALUE);
            }
        }
        catch (Throwable ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static DatabaseType getDBType() {
        if (props == null) {
            HTSProperties usProps = HTSServerProperties.getInstance();
            String dbType = usProps.getProperty(DB_TYPE);
            return DatabaseType.valueOf((String)dbType);
        }
        return props.getDBType();
    }

    public static JDBCConfigurationImpl createConfig() throws HumanTaskServiceException {
        HTSServerProperties.getInstance();
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
        conf.fromProperties(configMap);
        conf.getDBDictionaryInstance().characterColumnSize = 50;
        return conf;
    }

    public synchronized EntityManagerFactory getEntityManagerFactory() {
        return OpenJPAUtil.getNamedEntityManagerFactory(DEFAULT);
    }

    public static synchronized EntityManagerFactory getNamedEntityManagerFactory(PersistenceUnit persistenceUnit) {
        EntityManagerFactory ret_value = null;
        if (emfs.containsKey((Object)persistenceUnit)) {
            ret_value = emfs.get((Object)persistenceUnit);
        } else {
            String persistenceUnitName = OpenJPAUtil.getPersistenceUnitName(persistenceUnit);
            ret_value = OpenJPAPersistence.createEntityManagerFactory((String)persistenceUnitName, (String)((String)configMap.get(JPA_PERSISTENCE_XML)), configMap);
            emfs.put(persistenceUnit, ret_value);
        }
        return ret_value;
    }

    public static String getPersistenceUnitName(PersistenceUnit persistenceUnit) {
        String persistenceUnitName = persistenceUnit.getName();
        if (OpenJPAUtil.getDBType().equals((Object)DatabaseType.MSSQL)) {
            persistenceUnitName = persistenceUnitName + "MSSQL";
        } else if (OpenJPAUtil.getDBType().equals((Object)DatabaseType.SYBASE)) {
            persistenceUnitName = persistenceUnitName + "SYBASE";
        } else if (OpenJPAUtil.getDBType().equals((Object)DatabaseType.INFORMIX)) {
            persistenceUnitName = persistenceUnitName + "INFORMIX";
        }
        return persistenceUnitName;
    }

    public OpenJPAUtil() {
    }

    public OpenJPAUtil(PersistenceUnit pu) {
        if (!initialized) {
            throw new IllegalArgumentException("jpa not initialized");
        }
        this.persistenceUnit = pu;
    }

    @Override
    public EntityManager getEntityManager() {
        if (this.m_session == null || !this.m_session.isOpen()) {
            this.m_session = OpenJPAUtil.getNamedEntityManagerFactory(this.persistenceUnit).createEntityManager();
        }
        return this.m_session;
    }

    @Override
    public void setEntityManager(EntityManager em) {
        this.m_session = em;
    }

    public void closeEntityManager() {
        if (this.m_transaction != null && this.m_transaction.isActive()) {
            this.commitTransaction();
        }
        if (this.m_session != null && this.m_session.isOpen()) {
            this.m_session.close();
        }
    }

    @Override
    public void beginTransaction() {
        if (this.getEntityManager() == null || this.m_transaction != null) {
            throw new RuntimeException("new transaction started when transaction is already open");
        }
        this.m_transaction = this.getEntityManager().getTransaction();
        this.m_transaction.begin();
    }

    @Override
    public void setTransactionIsolation(int isolation) {
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)this.getEntityManager());
        try {
            ((Connection)kem.getConnection()).setTransactionIsolation(isolation);
        }
        catch (SQLException e) {
            Utils.logException(e);
        }
    }

    @Override
    public int getTransactionIsolation() {
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)this.getEntityManager());
        int level = -1;
        try {
            level = ((Connection)kem.getConnection()).getTransactionIsolation();
        }
        catch (SQLException e) {
            Utils.logException(e);
        }
        return level;
    }

    @Override
    public boolean inTransaction() {
        return this.m_transaction != null && this.m_transaction.isActive();
    }

    @Override
    public void commitTransaction() {
        if (this.m_transaction == null || !this.m_transaction.isActive()) {
            throw new RuntimeException("commit transaction called when no transaction active");
        }
        this.m_transaction.commit();
        this.m_transaction = null;
    }

    @Override
    public void rollbackTransaction() {
        if (this.m_transaction != null && this.m_transaction.isActive()) {
            this.m_transaction.rollback();
        }
        this.m_transaction = null;
    }

    @Override
    public void closeSession() {
        this.closeEntityManager();
    }

    @Override
    public void openSession() {
        this.getEntityManager();
    }

    public static void destroy() {
        for (EntityManagerFactory emf : emfs.values()) {
            if (emf == null) continue;
            emf.close();
        }
        emfs.clear();
        initialized = false;
    }

    static {
        initialized = false;
    }
}

