/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.openjpa;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.jdbc.dictionary.DBDictionaryFactory;
import com.ibm.cognos.internal.hts.persist.jdbc.dictionary.IDBDictionary;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class SchemaConfigurationPlugin {
    public static final String OPENJPA_JDBC_SCHEMA_KEY = "openjpa.jdbc.Schema";
    public static final String MSSQL_2008_AND_UP = "mssql.2008.and.up";

    public void configure(Map<String, Object> configuration, Connection connection) {
        String schema = null;
        String username = null;
        DatabaseMetaData metadata = null;
        try {
            metadata = connection.getMetaData();
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("Database exception while obtaining meta data.");
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex);
            return;
        }
        try {
            username = metadata.getUserName();
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("Database exception while obtaining connection user name.");
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex);
            return;
        }
        try {
            schema = this.determineSchemaFromConnection(connection, metadata, configuration);
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("Database exception while determining current schema.");
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex);
        }
        if (null == schema) {
            schema = username;
        }
        configuration.put(OPENJPA_JDBC_SCHEMA_KEY, schema);
        SDSLogger.getLogger((SDSCategory)USCategory.TRACE).debug("Set openjpa.jdbc.Schema property to " + schema);
    }

    private String determineSchemaFromConnection(Connection connection, DatabaseMetaData metadata, Map<String, Object> configuration) throws SQLException {
        DBDictionaryFactory factory = new DBDictionaryFactory();
        IDBDictionary dictionary = factory.getDictionary(metadata, configuration);
        PreparedStatement stmt = dictionary.getCurrentSchemaPreparedStatement(connection);
        if (null != stmt) {
            return this.executeSchemaQuery(stmt);
        }
        return null;
    }

    private String executeSchemaQuery(PreparedStatement stmt) throws SQLException {
        ResultSet rs = stmt.executeQuery();
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }
}

