/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.openjpa;

import com.ibm.cognos.internal.hts.persist.dao.PostDAO;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.AbstractOpenJPADAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPost;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import java.util.List;
import javax.persistence.Query;

public class UsPostOpenJPADAO
extends AbstractOpenJPADAO<HTSPost, String>
implements PostDAO {
    @Override
    public HTSTask findOwnerTask(String postId) {
        String queryStr = "select ownerTask from HTSTask ownerTask JOIN ownerTask.htsThreads thread JOIN thread.htsPosts post where post.id = :postId ";
        Query query = this.getEntityManager().createQuery(queryStr);
        query.setParameter("postId", (Object)postId);
        return (HTSTask)query.getSingleResult();
    }

    @Override
    public List<HTSPost> findPosts(String threadId) {
        String queryStr = "select posts from HTSPost posts JOIN posts.htsThread thread where thread.id = :threadId ";
        Query query = this.getEntityManager().createQuery(queryStr);
        query.setParameter("threadId", (Object)threadId);
        return query.getResultList();
    }

    @Override
    public List<HTSTask> findChildTasks(String taskId) {
        String queryStr = "select task from HTSTask ownerTask JOIN ownerTask.htsThreads thread JOIN thread.htsPosts post JOIN post.htsPostTasks task where ownerTask.id = :taskId ";
        Query query = this.getEntityManager().createQuery(queryStr);
        query.setParameter("taskId", (Object)taskId);
        return query.getResultList();
    }

    @Override
    public List<HTSPost> findParentPosts(String taskId) {
        String queryStr = "select post from HTSPost post JOIN post.htsPostTasks task where task.id = :taskId ";
        Query query = this.getEntityManager().createQuery(queryStr);
        query.setParameter("taskId", (Object)taskId);
        return query.getResultList();
    }

    @Override
    public List<HTSTask> findParentTasks(String taskId) {
        String queryStr = "select ownerTask from HTSTask ownerTask JOIN ownerTask.htsThreads thread JOIN thread.htsPosts post JOIN post.htsPostTasks task where task.id = :taskId ";
        Query query = this.getEntityManager().createQuery(queryStr);
        query.setParameter("taskId", (Object)taskId);
        return query.getResultList();
    }

    @Override
    public List<HTSPost> findByUserAndDate(String userId, long date) {
        String queryStr = "select post from HTSPost post where post.createDate = :createDate and post.htsTaskUser.id = :userId  ";
        Query query = this.getEntityManager().createQuery(queryStr);
        query.setParameter("createDate", (Object)date);
        query.setParameter("userId", (Object)userId);
        return query.getResultList();
    }
}

