/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.openjpa;

import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.Criteria;
import com.ibm.cognos.internal.hts.persist.dao.CriteriaImpl;
import com.ibm.cognos.internal.hts.persist.dao.OrderByClause;
import com.ibm.cognos.internal.hts.persist.dao.SelectClause;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.persist.dao.TaskSearchProperties;
import com.ibm.cognos.internal.hts.persist.dao.WhereClause;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.AbstractOpenJPADAO;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.GetTasksOrderByClause;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.GetTasksSelectClause;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.GetTasksWhereClause;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.Registry;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.TaskUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;

public class UsTaskOpenJPADAO
extends AbstractOpenJPADAO<HTSTask, String>
implements TaskDAO {
    private static String INBOX_FROM = " FROM HTSHumanRole humanrole JOIN humanrole.htsTask task JOIN humanrole.htsTaskUser taskuser LEFT OUTER JOIN task.taskFolders folders";
    private static final String FROM = INBOX_FROM + " LEFT OUTER JOIN " + "task" + ".deadlineInstances " + "taskDeadline";
    private static final String USER_PARAM = "userId";
    private static int inClauseLimit = 500;
    private TaskSearchProperties m_properties = Registry.getService(TaskSearchProperties.class);
    private IAbstractContext context = null;

    public IAbstractContext getContext() {
        return this.context;
    }

    public void setContext(IAbstractContext context) {
        this.context = context;
    }

    public List<HTSTask> findByCriteriaForUsersChunk(Criteria criteria, Set<String> userTokens, HTSTaskUser currentUser) {
        StringBuffer jpql = new StringBuffer();
        jpql.append(criteria.getSelectClause().getClause());
        jpql.append(FROM);
        String where = criteria.getWhereClause().getClause();
        if (where.length() > 0) {
            jpql.append(" ").append(where).append(" AND ");
        } else {
            jpql.append(" WHERE ");
        }
        if (userTokens == null || userTokens.size() == 0) {
            jpql.append("taskuser.userToken IS NULL");
        } else {
            jpql.append("taskuser.userToken IN (:tokens)");
        }
        String orderBy = criteria.getOrderByClause().getClause();
        if (orderBy.length() > 0) {
            jpql.append(" ").append(orderBy);
        }
        String queryStr = jpql.toString();
        Query query = this.getEntityManager().createQuery(queryStr);
        if (userTokens != null && userTokens.size() != 0) {
            query.setParameter("tokens", userTokens);
        }
        return this.buildResult(query, criteria);
    }

    @Override
    public List<HTSTask> findByCriteriaForUsers(Criteria criteria, Set<String> userTokens, HTSTaskUser currentUser) {
        int inClauseLimit = this.getInClauseLimit();
        int taskListSize = 0;
        int myInboxListFetchSize = criteria.getMaxReturnCount();
        ArrayList<HTSTask> tasks = new ArrayList<HTSTask>();
        Iterator<String> tokens = userTokens.iterator();
        HashSet<String> tokenSubset = null;
        while (tokens.hasNext() && (myInboxListFetchSize <= 0 || taskListSize < myInboxListFetchSize)) {
            tokenSubset = new HashSet<String>();
            for (int i = 0; i < inClauseLimit && tokens.hasNext(); ++i) {
                tokenSubset.add(tokens.next());
            }
            if (myInboxListFetchSize > 0 && taskListSize < myInboxListFetchSize) {
                criteria.setMaxReturnCount(myInboxListFetchSize - taskListSize);
            }
            tasks.addAll(this.findByCriteriaForUsersChunk(criteria, tokenSubset, currentUser));
            taskListSize = tasks.size();
        }
        return tasks;
    }

    private List<HTSTask> buildResult(Query query, Criteria criteria) {
        query.setFirstResult(criteria.getReturnOffset());
        if (criteria.getMaxReturnCount() > 0) {
            query.setMaxResults(criteria.getMaxReturnCount());
        }
        if (query instanceof OpenJPAQuery) {
            OpenJPAQuery kq = OpenJPAPersistence.cast((Query)query);
            JDBCFetchPlan fetch = (JDBCFetchPlan)kq.getFetchPlan();
            fetch.addField(HTSTask.class, "htsHumanRoles");
            fetch.addField(HTSTask.class, "htsMessages");
            fetch.addField(HTSTask.class, "htsPresentationElements");
            fetch.addField(HTSTask.class, "deadlineInstances");
            fetch.addField(HTSTask.class, "createdBy");
            fetch.addField(HTSTask.class, "actualOwner");
            fetch.addField(HTSTask.class, "taskInitiator");
            fetch.addField(HTSTaskUser.class, "htsTaskUserDisplayNames");
            fetch.setMaxFetchDepth(2);
            fetch.setFetchBatchSize(20);
        }
        criteria.getWhereClause().setParameterValues(query);
        List<HTSTask> resultSet = query.getResultList();
        resultSet = criteria.getSelectClause().buildResultObjects(resultSet);
        return this.trimResultSet(resultSet);
    }

    @Override
    public List<HTSTask> findByCriteria(Criteria criteria) {
        String orderBy;
        StringBuffer jpql = new StringBuffer();
        jpql.append(criteria.getSelectClause().getClause());
        jpql.append(FROM);
        String where = criteria.getWhereClause().getClause();
        if (where.length() > 0) {
            jpql.append(" ").append(where);
        }
        if ((orderBy = criteria.getOrderByClause().getClause()).length() > 0) {
            jpql.append(" ").append(orderBy);
        }
        String queryStr = jpql.toString();
        Query query = this.getEntityManager().createQuery(queryStr);
        query.setFirstResult(criteria.getReturnOffset());
        if (criteria.getMaxReturnCount() > 0) {
            query.setMaxResults(criteria.getMaxReturnCount());
        }
        criteria.getWhereClause().setParameterValues(query);
        List<HTSTask> resultSet = query.getResultList();
        resultSet = criteria.getSelectClause().buildResultObjects(resultSet);
        return resultSet;
    }

    private List<HTSTask> trimResultSet(List<HTSTask> tasks) {
        HashSet<HTSTask> taskSet = new HashSet<HTSTask>();
        ArrayList<HTSTask> taskList = new ArrayList<HTSTask>();
        for (HTSTask task : tasks) {
            if (taskSet.contains(task)) continue;
            taskSet.add(task);
            taskList.add(task);
        }
        return taskList;
    }

    @Override
    public List<HTSTask> findFolderlessTasks(HTSTaskUser currentUser, Set<String> userTokens) {
        List<HTSTask> tasks = new ArrayList<HTSTask>();
        int inClauseLimit = this.getInClauseLimit();
        int updateInboxFetchSize = TaskUtil.getUpdateInboxFetchSize(this.context);
        int iterationCount = 0;
        if (currentUser != null) {
            if (userTokens != null) {
                userTokens.add(currentUser.getUserToken());
            }
            Utils.debug("USTaskOpenJPADAO : findFolderlessTasks : 1 : total number of user tokens : " + (userTokens != null ? Integer.valueOf(userTokens.size()) : null));
            if (userTokens != null && userTokens.size() > inClauseLimit) {
                Iterator<String> tokens = userTokens.iterator();
                HashSet<String> tokenSubset = null;
                while (tokens.hasNext() && tasks.size() < updateInboxFetchSize) {
                    tokenSubset = new HashSet<String>();
                    for (int i = 0; i < inClauseLimit && tokens.hasNext(); ++i) {
                        tokenSubset.add(tokens.next());
                    }
                    tasks.addAll(this.findFolderlessTasksChunk(currentUser, tokenSubset));
                    ++iterationCount;
                }
            } else {
                tasks = this.findFolderlessTasksChunk(currentUser, userTokens);
            }
            Utils.debug("USTaskOpenJPADAO : findFolderlessTasks : 2 : inClauseLimit : " + inClauseLimit + " : updateInboxFetchSize : " + updateInboxFetchSize + " : iterationCount : " + iterationCount);
        }
        Utils.debug("USTaskOpenJPADAO : findFolderlessTasks : 3 : total number of tasks found : " + tasks.size());
        return tasks;
    }

    public List<HTSTask> findFolderlessTasksChunk(HTSTaskUser currentUser, Set<String> userTokens) {
        StringBuffer slect = new StringBuffer("SELECT DISTINCT task " + INBOX_FROM + " WHERE ");
        if (userTokens == null || userTokens.size() == 0) {
            slect.append("taskuser.userToken IS NULL");
        } else {
            slect.append("taskuser.userToken IN (:tokens)");
        }
        slect.append(" AND NOT EXISTS(SELECT folder From HTSFolder folder WHERE folder.htsTask.id = task.id AND folder.htsTaskuser.id = :userId)");
        slect.append(" ORDER BY task.createdOn DESC");
        Query query = this.getEntityManager().createQuery(slect.toString());
        query.setParameter(USER_PARAM, (Object)currentUser.getId());
        if (userTokens != null && userTokens.size() != 0) {
            query.setParameter("tokens", userTokens);
        }
        OpenJPAQuery kq = OpenJPAPersistence.cast((Query)query);
        JDBCFetchPlan fetch = (JDBCFetchPlan)kq.getFetchPlan();
        fetch.addField(HTSTask.class, "taskFolders");
        int updateInboxFetchSize = TaskUtil.getUpdateInboxFetchSize();
        if (updateInboxFetchSize > 0) {
            query.setMaxResults(updateInboxFetchSize);
        }
        List tasks = query.getResultList();
        return tasks;
    }

    @Override
    public List<HTSTask> findParentTask(String taskId) {
        Query query = this.getEntityManager().createQuery("SELECT task FROM HTSTask task JOIN task.childTasks childTask where childTask.id = :taskId");
        query.setParameter("taskId", (Object)taskId);
        return query.getResultList();
    }

    @Override
    public List<HTSTask> findByPostId(String postId) {
        Query query = this.getEntityManager().createQuery("SELECT task FROM HTSTask task JOIN task.htsThreads thread JOIN thread.htsPosts post where post.id = :postId");
        query.setParameter("postId", (Object)postId);
        return query.getResultList();
    }

    @Override
    public List<HTSTask> findByName(String name) {
        Query query = this.getEntityManager().createQuery("select a from HTSTask a where a.name = :name");
        query.setParameter("name", (Object)name);
        return query.getResultList();
    }

    @Override
    public List<HTSTask> findByTaskClass(HTSTaskclass tc) {
        Query query = this.getEntityManager().createQuery("select a from HTSTask a where a.operation = :operation AND a.taskClassVersion = :version");
        query.setParameter("version", (Object)tc.getVersionId());
        query.setParameter("operation", (Object)tc.getOperation());
        return query.getResultList();
    }

    @Override
    public Criteria buildCriteria() {
        CriteriaImpl criteria = new CriteriaImpl();
        criteria.setOrderByClause(this.getOrderByClause());
        criteria.setSelectClause(this.getSelectClause());
        criteria.setWhereClause(this.getWhereClause());
        return criteria;
    }

    OrderByClause getOrderByClause() {
        return new GetTasksOrderByClause(this.m_properties);
    }

    SelectClause getSelectClause() {
        return new GetTasksSelectClause(this.m_properties);
    }

    WhereClause getWhereClause() {
        return new GetTasksWhereClause(this.m_properties);
    }

    public int getInClauseLimit() {
        return inClauseLimit;
    }
}

