/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.openjpa;

import com.ibm.cognos.internal.hts.persist.dao.TaskuserDAO;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.AbstractOpenJPADAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Query;

public class UsTaskuserOpenJPADAO
extends AbstractOpenJPADAO<HTSTaskUser, String>
implements TaskuserDAO {
    @Override
    public List<HTSTaskUser> findByUser(String userToken, String logicalPeopleGroup) {
        Query query = this.getEntityManager().createQuery("select a from HTSTaskUser a where a.userToken = :userToken and a.logicalPeopleGroup = :logicalPeopleGroup");
        query.setParameter("userToken", (Object)userToken);
        query.setParameter("logicalPeopleGroup", (Object)logicalPeopleGroup);
        return query.getResultList();
    }

    private List<String> getUserTokens(Collection<HTSTaskUser> users) {
        ArrayList<String> userTokens = new ArrayList<String>();
        if (users != null) {
            for (HTSTaskUser htsTaskUser : users) {
                if (htsTaskUser == null || htsTaskUser.getUserToken() == null || htsTaskUser.getUserToken().trim().equals("")) continue;
                userTokens.add(htsTaskUser.getUserToken());
            }
        }
        return userTokens;
    }

    @Override
    public List<HTSTaskUser> findByUser(Collection<HTSTaskUser> users) {
        Query query = this.getEntityManager().createQuery("select a from HTSTaskUser a where a.userToken in (:userToken)");
        query.setParameter("userToken", this.getUserTokens(users));
        List queryResult = query.getResultList();
        ArrayList<HTSTaskUser> resultList = new ArrayList<HTSTaskUser>();
        String userToken = "";
        String lpg = "";
        for (HTSTaskUser htsTaskUser : users) {
            if (htsTaskUser == null) continue;
            userToken = htsTaskUser.getUserToken();
            lpg = htsTaskUser.getLogicalPeopleGroup();
            if (userToken == null || userToken.trim().equals("") || lpg == null || lpg.trim().equals("")) continue;
            for (HTSTaskUser taskUser : queryResult) {
                if (taskUser == null || !userToken.equals(taskUser.getUserToken()) || !lpg.equals(taskUser.getLogicalPeopleGroup())) continue;
                resultList.add(taskUser);
            }
        }
        return resultList;
    }
}

