/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.openjpa;

import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.VersionDAO;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.AbstractOpenJPADAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSVersion;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.Query;

public class UsVersionOpenJPADAO
extends AbstractOpenJPADAO<HTSVersion, String>
implements VersionDAO {
    @Override
    public HTSVersion findVersion() {
        Query query = this.getEntityManager().createQuery("select a from HTSVersion a order by a.dbVersionId desc");
        query.setMaxResults(1);
        List results = query.getResultList();
        return results == null || results.size() == 0 ? null : (HTSVersion)results.get(0);
    }

    @Override
    public int getNativeVersion(Connection con) throws HumanTaskServiceException {
        PreparedStatement versionStatement = null;
        ResultSet resultSet = null;
        int version = 0;
        try {
            versionStatement = con.prepareStatement("select dbVersionId from HTS_VERSION");
            resultSet = versionStatement.executeQuery();
            while (resultSet.next()) {
                int tempVersion = resultSet.getInt(1);
                if (tempVersion <= version) continue;
                version = tempVersion;
            }
        }
        catch (SQLException e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()}, e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (versionStatement != null) {
                    versionStatement.close();
                    versionStatement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
        return version;
    }
}

