/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.pojo;

import java.util.ArrayList;
import java.util.List;

public class HTSRole {
    private static List<HTSRole> roles = new ArrayList<HTSRole>();
    public static final HTSRole BUSINESS_ADMINISTRATORS = new HTSRole("BusinessAdministrators");
    public static final HTSRole POTENTIAL_OWNERS = new HTSRole("PotentialOwners");
    public static final HTSRole TASK_STAKEHOLDERS = new HTSRole("TaskStakeholders");
    public static final HTSRole EXLUDED_OWNERS = new HTSRole("ExcludedOwners");
    public static final HTSRole TASK_INITIATORS = new HTSRole("TaskInitiators");
    public static final HTSRole NOTIFICATION_RECIPIENTS = new HTSRole("NotificationRecipients");
    public static final HTSRole ACTUAL_OWNER = new HTSRole("ActualOwner");
    public static final HTSRole ANY = new HTSRole("Any");
    private String role;

    public static HTSRole fromRole(String roleString) {
        for (HTSRole role : roles) {
            if (!role.getRole().equals(roleString)) continue;
            return role;
        }
        return null;
    }

    private HTSRole(String role) {
        this.role = role;
        roles.add(this);
    }

    public String getRole() {
        return this.role;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    public static enum Roles {
        BUSINESS_ADMINISTRATORS("BusinessAdministrators"),
        POTENTIAL_OWNERS("PotentialOwners"),
        TASK_STAKEHOLDERS("TaskStakeholders"),
        EXLUDED_OWNERS("ExcludedOwners"),
        TASK_INITIATORS("TaskInitiators"),
        NOTIFICATION_RECIPIENTS("NotificationRecipients"),
        ACTUAL_OWNER("ActualOwner"),
        ANY("Any");

        private String m_role;

        private Roles(String role) {
            this.m_role = role;
        }

        public String getRole() {
            return this.m_role;
        }

        public HTSRole getHtsRole() {
            return HTSRole.fromRole(this.m_role);
        }

        public static Roles findRole(String name) {
            Roles role = ANY;
            if (name == null) {
                return role;
            }
            if (name.equalsIgnoreCase(BUSINESS_ADMINISTRATORS.getRole())) {
                role = BUSINESS_ADMINISTRATORS;
            } else if (name.equalsIgnoreCase(POTENTIAL_OWNERS.getRole())) {
                role = POTENTIAL_OWNERS;
            } else if (name.equalsIgnoreCase(TASK_STAKEHOLDERS.getRole())) {
                role = TASK_STAKEHOLDERS;
            } else if (name.equalsIgnoreCase(EXLUDED_OWNERS.getRole())) {
                role = EXLUDED_OWNERS;
            } else if (name.equalsIgnoreCase(TASK_INITIATORS.getRole())) {
                role = TASK_INITIATORS;
            } else if (name.equalsIgnoreCase(NOTIFICATION_RECIPIENTS.getRole())) {
                role = NOTIFICATION_RECIPIENTS;
            } else if (name.equalsIgnoreCase(ACTUAL_OWNER.getRole())) {
                role = ACTUAL_OWNER;
            } else if (name.equalsIgnoreCase(ANY.getRole())) {
                role = ANY;
            }
            return role;
        }
    }
}

