/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.pojo;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TGenericHumanRole;
import com.ibm.cognos.internal.hts.ws_ht.TPeopleAssignments;

public class HTSTaskOverrides {
    private HTSTaskclass taskclass;
    private String taskMessageId;
    private TPeopleAssignments[] peopleAssignments;

    public TPeopleAssignments[] getPeopleAssignments() {
        return this.peopleAssignments;
    }

    public boolean hasRecipients() {
        int recipCount = 0;
        for (int i = 0; i < this.peopleAssignments.length; ++i) {
            recipCount += this.count(this.peopleAssignments[i].getPotentialOwnersArray());
            recipCount += this.count(this.peopleAssignments[i].getTaskStakeholdersArray());
            recipCount += this.count(this.peopleAssignments[i].getRecipientsArray());
        }
        return recipCount > 0;
    }

    private int count(TGenericHumanRole[] roles) {
        int count = 0;
        for (int i = 0; i < roles.length; ++i) {
            try {
                OrganizationalEntityDocument org = HTSSDKUtils.getOrganizationalEntity(roles[i].getFrom().getLiteral());
                count += org.getOrganizationalEntity().sizeOfGroupsArray();
                count += org.getOrganizationalEntity().sizeOfUsersArray();
                continue;
            }
            catch (HumanTaskServiceException humanTaskServiceException) {
                // empty catch block
            }
        }
        return count;
    }

    public void setStateChangeHumanRoles(TPeopleAssignments[] peopleAssignments) {
        this.peopleAssignments = peopleAssignments;
    }

    public void setTaskMessageId(String taskMessageId) {
        this.taskMessageId = taskMessageId;
    }

    public String getTaskMessageId() {
        return this.taskMessageId;
    }

    public HTSTaskclass getTaskclass() {
        return this.taskclass;
    }

    public void setTaskclass(HTSTaskclass taskclass) {
        this.taskclass = taskclass;
    }
}

