/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.dao.pojo;

import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.TaskclassDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class PojoCache {
    private static Map<String, Object> pojos = new HashMap<String, Object>();
    private static boolean tcOff = false;

    public static void switchOn() {
        tcOff = false;
    }

    public static void switchOff() {
        tcOff = true;
    }

    public static void clear() {
        pojos.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskClassVersion(HTSTaskclass tc) {
        PojoCache pojoCache = this;
        synchronized (pojoCache) {
            TaskClassVersion tcv = (TaskClassVersion)pojos.get(tc.getOperation());
            if (tcv == null) {
                tcv = new TaskClassVersion(tc);
                pojos.put(tc.getOperation(), tcv);
                pojos.put(tc.getName(), tcv);
            } else {
                tcv.add(tc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTSTaskclass getLatestTaskClassByName(String name) {
        TaskClassVersion tcv;
        if (tcOff) {
            return this.findLatestTaskClassByName(name);
        }
        HTSTaskclass tc = null;
        PojoCache pojoCache = this;
        synchronized (pojoCache) {
            tcv = (TaskClassVersion)pojos.get(name);
            if (tcv == null && (tc = this.findLatestTaskClassByName(name)) != null) {
                tcv = new TaskClassVersion(tc);
                pojos.put(tc.getOperation(), tcv);
                pojos.put(name, tcv);
            }
        }
        if (tcv != null && tc == null) {
            tc = tcv.getLatestTaskClass();
        }
        if (tcv != null && tc == null) {
            tc = this.findLatestTaskClassByName(name);
            tcv.add(tc);
        }
        return tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTSTaskclass getLatestTaskClass(String operation) {
        TaskClassVersion tcv;
        if (tcOff) {
            return this.findLatestTaskClass(operation);
        }
        HTSTaskclass tc = null;
        PojoCache pojoCache = this;
        synchronized (pojoCache) {
            tcv = (TaskClassVersion)pojos.get(operation);
            if (tcv == null && (tc = this.findLatestTaskClass(operation)) != null) {
                tcv = new TaskClassVersion(tc);
                pojos.put(operation, tcv);
                pojos.put(tc.getName(), tcv);
            }
        }
        if (tcv != null && tc == null) {
            tc = tcv.getLatestTaskClass();
        }
        if (tcv != null && tc == null) {
            tc = this.findLatestTaskClass(operation);
            tcv.add(tc);
        }
        return tc;
    }

    private HTSTaskclass findLatestTaskClassByName(String name) {
        TaskclassDAO tcDao = DAOFactory.getFactory().buildTaskclassDAO();
        List<HTSTaskclass> taskList = tcDao.findLatestByName(name);
        return taskList == null || taskList.size() == 0 ? null : taskList.get(0);
    }

    private HTSTaskclass findLatestTaskClass(String operation) {
        TaskclassDAO tcDao = DAOFactory.getFactory().buildTaskclassDAO();
        List<HTSTaskclass> taskList = tcDao.findLatestByOperation(operation);
        return taskList == null || taskList.size() == 0 ? null : taskList.get(0);
    }

    private HTSTaskclass findTaskClass(String operation, String version) {
        TaskclassDAO tcDao = DAOFactory.getFactory().buildTaskclassDAO();
        List<HTSTaskclass> taskList = tcDao.findByOperation(operation, version);
        return taskList == null || taskList.size() == 0 ? null : taskList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTSTaskclass getTaskClass(HTSTask task) {
        TaskClassVersion tcv;
        if (tcOff) {
            return this.findTaskClass(task.getOperation(), task.getTaskClassVersion());
        }
        HTSTaskclass tc = null;
        PojoCache pojoCache = this;
        synchronized (pojoCache) {
            tcv = (TaskClassVersion)pojos.get(task.getOperation());
            if (tcv == null && (tc = this.findTaskClass(task.getOperation(), task.getTaskClassVersion())) != null) {
                tcv = new TaskClassVersion(tc);
                pojos.put(task.getOperation(), tcv);
                pojos.put(tc.getName(), tcv);
            }
        }
        if (tcv != null && tc == null) {
            tc = tcv.getTaskClass(task.getTaskClassVersion());
        }
        if (tcv != null && tc == null) {
            tc = this.findTaskClass(task.getOperation(), task.getTaskClassVersion());
            tcv.add(tc);
        }
        return tc;
    }

    public static Object merge(Object pojo) {
        EntityManager em;
        OpenJPAEntityManager kem;
        if (pojo != null && (kem = OpenJPAPersistence.cast((EntityManager)(em = AbstractContext.getCurrentTransactionHandler().getEntityManager()))).isDetached(pojo)) {
            pojo = kem.merge(pojo);
        }
        return pojo;
    }

    public static Object detach(Object pojo) {
        EntityManager em;
        OpenJPAEntityManager kem;
        ITransactionHandler handler;
        if (pojo != null && (handler = AbstractContext.getCurrentTransactionHandler()) != null && !(kem = OpenJPAPersistence.cast((EntityManager)(em = AbstractContext.getCurrentTransactionHandler().getEntityManager()))).isDetached(pojo)) {
            kem.detach(pojo);
        }
        return pojo;
    }

    private class TaskClassVersion {
        private Map<String, HTSTaskclass> tcMap = new HashMap<String, HTSTaskclass>();
        private String operation;

        public TaskClassVersion(HTSTaskclass tc) {
            this.operation = tc.getOperation();
            this.tcMap.put(tc.getVersionId(), (HTSTaskclass)PojoCache.detach(tc));
            tc.getHtsRenderings();
            tc.getHtsDeadlines();
        }

        public void add(HTSTaskclass tc) {
            if (this.operation.equals(tc.getOperation())) {
                this.tcMap.put(tc.getVersionId(), (HTSTaskclass)PojoCache.detach(tc));
            }
        }

        public HTSTaskclass getTaskClass(String version) {
            return this.getFromMap(version);
        }

        public HTSTaskclass getLatestTaskClass() {
            HTSTaskclass tc = null;
            int max = -1;
            for (String key : this.tcMap.keySet()) {
                int version = Integer.valueOf(key);
                if (version <= max) continue;
                max = version;
                tc = this.getFromMap(key);
            }
            return tc;
        }

        private HTSTaskclass getFromMap(String key) {
            return this.tcMap.get(key);
        }
    }
}

