/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.persist.jdbc.dictionary;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.jdbc.dictionary.DB2Dictionary;
import com.ibm.cognos.internal.hts.persist.jdbc.dictionary.DB2zOSDictionary;
import com.ibm.cognos.internal.hts.persist.jdbc.dictionary.DefaultDictionary;
import com.ibm.cognos.internal.hts.persist.jdbc.dictionary.HsqlDictionary;
import com.ibm.cognos.internal.hts.persist.jdbc.dictionary.IDBDictionary;
import com.ibm.cognos.internal.hts.persist.jdbc.dictionary.SQLServer2005Dictionary;
import com.ibm.cognos.internal.hts.persist.jdbc.dictionary.SQLServerDictionary;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;

public class DBDictionaryFactory {
    public IDBDictionary getDictionary(DatabaseMetaData metadata) {
        return this.getDictionary(metadata, null);
    }

    public IDBDictionary getDictionary(DatabaseMetaData metadata, Map<String, Object> configuration) {
        try {
            String productName = metadata.getDatabaseProductName();
            if (null != productName) {
                if (productName.equalsIgnoreCase("Microsoft SQL Server")) {
                    int majorVersion = metadata.getDatabaseMajorVersion();
                    if (configuration != null && majorVersion >= 10) {
                        configuration.put("mssql.2008.and.up", true);
                    }
                    if (9 > majorVersion) {
                        return this.chooseDBDictionary(new SQLServerDictionary());
                    }
                    return this.chooseDBDictionary(new SQLServer2005Dictionary());
                }
                if (productName.startsWith("DB2")) {
                    if (productName.equals("DB2")) {
                        return this.chooseDBDictionary(new DB2zOSDictionary());
                    }
                    return this.chooseDBDictionary(new DB2Dictionary());
                }
                if (0 == productName.length()) {
                    if (metadata.getDriverName().startsWith("IBM DB2")) {
                        return this.chooseDBDictionary(new DB2Dictionary());
                    }
                } else {
                    if (productName.equalsIgnoreCase("Apache Derby")) {
                        return this.chooseDBDictionary(new DB2Dictionary());
                    }
                    if (productName.equals("HSQL Database Engine")) {
                        return this.chooseDBDictionary(new HsqlDictionary());
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.chooseDBDictionary(new DefaultDictionary());
    }

    private IDBDictionary chooseDBDictionary(IDBDictionary dictionary) {
        SDSLogger.getLogger((SDSCategory)USCategory.TRACE).debug("HTS using " + dictionary.getClass().getName() + " as its dictionary.");
        return dictionary;
    }
}

