/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.properties;

import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.Filter;
import com.ibm.cognos.internal.hts.properties.HTSProperties;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class HTSServerProperties {
    private static String[] PROPS_FILES = new String[]{"/humanTaskService.properties"};
    private static String TEST_PROPERTIES = "test.properties";
    private static HTSProperties m_instance = new USServerPropertiesImpl();

    public static HTSProperties getInstance() {
        return m_instance;
    }

    public static void setInstance(HTSProperties properties) {
        m_instance = properties;
    }

    public static void resetInstance() {
        m_instance = new USServerPropertiesImpl();
    }

    public static class USServerTestPropertiesImpl
    extends USServerPropertiesImpl {
        @Override
        public void setProperty(String key, String value) {
            this.properties.setProperty(key, value);
        }
    }

    private static class USServerPropertiesImpl
    implements HTSProperties {
        protected Properties properties = new Properties();

        public USServerPropertiesImpl() {
            for (int i = 0; i < PROPS_FILES.length; ++i) {
                String file = PROPS_FILES[i];
                InputStream stream = HTSServerProperties.class.getResourceAsStream(file);
                try {
                    this.properties.load(stream);
                    this.loadTestProperties();
                    continue;
                }
                catch (Throwable e) {
                    Utils.logException(e);
                }
            }
        }

        private void loadTestProperties() throws IOException {
            String testPath = this.properties.getProperty(TEST_PROPERTIES);
            if (testPath != null && !testPath.equals("")) {
                try {
                    FileInputStream stream = new FileInputStream(testPath);
                    this.properties.load(stream);
                }
                catch (Exception e) {
                    Utils.logException(e);
                    InputStream stream = HTSServerProperties.class.getResourceAsStream(testPath);
                    this.properties.load(stream);
                }
            }
        }

        @Override
        public Map<String, String> getProperties(Filter propertyFilter) {
            HashMap<String, String> testProperties = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String key = (String)entry.getKey();
                if (!propertyFilter.accept(entry)) continue;
                testProperties.put(key, entry.getValue().toString());
            }
            return testProperties;
        }

        @Override
        public String getProperty(String key) {
            String prop = null;
            prop = this.properties.getProperty(key);
            if ("".equals(prop)) {
                prop = null;
            }
            if (prop == null) {
                try {
                    prop = CRNProperties.getInstance().getProperty(key);
                }
                catch (PropertiesException e) {
                    Utils.logException(e);
                }
            }
            return prop;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public void setProperty(String name, String value) {
            this.properties.setProperty(name, value);
        }
    }
}

