/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.schema;

import com.cognos.jsmcommon.version.repository.DBType;
import com.cognos.jsmcommon.version.repository.DBVersionDocument;
import com.cognos.jsmcommon.version.repository.InstallType;
import com.cognos.jsmcommon.version.repository.SQLStatementExecutor;
import com.cognos.jsmcommon.version.repository.ScriptMetadata;
import com.cognos.jsmcommon.version.repository.ScriptValidator;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.schema.SchemaVersionInstall;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class HTSRoboRepository
implements SchemaVersionInstall {
    private static final boolean VERBOSE = true;
    private PersistenceUnit pu;
    private boolean failOnError;

    public HTSRoboRepository(PersistenceUnit pu, boolean failOnError) {
        this.pu = pu;
        this.failOnError = failOnError;
    }

    public HTSRoboRepository(PersistenceUnit pu) {
        this(pu, false);
    }

    @Override
    public void install(int version) throws HumanTaskServiceException {
        this.execute(version, InstallType.CREATE);
    }

    private void execute(int version, InstallType installType) throws HumanTaskServiceException {
        boolean success = false;
        try {
            String scriptRootExtension = this.pu == PersistenceUnit.ANNOTATIONS ? "ans" : "hts";
            DBType dbType = new DBType("HTS", scriptRootExtension);
            DBVersionDocument dbVer = new DBVersionDocument(dbType.getXmlFile(), true);
            ScriptMetadata[] smda = dbVer.getScriptMetadata(installType);
            smda = this.trimMetaDataToVersion(smda, version);
            ScriptValidator sv = new ScriptValidator(dbType, true, smda);
            SQLStatementExecutor sqlExec = new SQLStatementExecutor(sv.getSQLStringList(), true, "HTS");
            success = sqlExec.execute(installType);
        }
        catch (Exception e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_SCHEMA_LIST, e);
        }
        if (!success && this.failOnError) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_SCHEMA_LIST);
        }
    }

    public void update(int fromVersion) throws HumanTaskServiceException {
        this.execute(fromVersion, InstallType.UPDATE);
    }

    public void drop() throws HumanTaskServiceException {
        this.execute(0, InstallType.DROP);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    private ScriptMetadata[] trimMetaDataToVersion(ScriptMetadata[] meta_data, int from_version) {
        ArrayList<ScriptMetadata> meta_data_list = new ArrayList<ScriptMetadata>();
        meta_data_list.addAll(Arrays.asList(meta_data));
        Iterator iter = meta_data_list.iterator();
        while (iter.hasNext()) {
            ScriptMetadata one_meta_data = (ScriptMetadata)iter.next();
            if (from_version == -1 || one_meta_data.getVersion() > from_version) continue;
            iter.remove();
        }
        ScriptMetadata[] trimmed_meta_data = new ScriptMetadata[meta_data_list.size()];
        meta_data_list.toArray(trimmed_meta_data);
        return trimmed_meta_data;
    }
}

