/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.schema;

import com.cognos.jsmcommon.util.Filter;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.properties.HTSServerProperties;
import com.ibm.cognos.internal.hts.schema.HTSRoboRepository;
import com.ibm.cognos.internal.hts.schema.SchemaVersionChangeFactory;
import com.ibm.cognos.internal.hts.schema.SchemaVersionInstall;
import com.ibm.cognos.internal.hts.schema.SchemaVersionNoUpdate;
import com.ibm.cognos.internal.hts.schema.SchemaVersionUpdate;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang.math.IntRange;
import org.apache.commons.lang.math.Range;

public class PluginPropertySchemaVersionUpdateFactory
implements SchemaVersionChangeFactory {
    public String updatePrefix;
    private EntityManagerFactory emf;
    Filter updateVersionFilter = new Filter(){

        public boolean accept(Object object) {
            return object != null && object.toString().startsWith(PluginPropertySchemaVersionUpdateFactory.this.updatePrefix);
        }
    };

    public PluginPropertySchemaVersionUpdateFactory(EntityManagerFactory emf, PersistenceUnit pu) {
        StringBuffer prefix = new StringBuffer();
        prefix.append(pu.getName());
        prefix.append(".");
        prefix.append("update");
        this.updatePrefix = prefix.toString();
        this.emf = emf;
    }

    @Override
    public SchemaVersionUpdate getSchemaVersionUpdate(int fromVersion) throws HumanTaskServiceException {
        String[] sortedUpdaterClassnames;
        SchemaVersionUpdate updater = null;
        Map<String, String> updateMap = HTSServerProperties.getInstance().getProperties(this.updateVersionFilter);
        for (String updateClassName : sortedUpdaterClassnames = this.getSortedUpdaterClassnames(updateMap, fromVersion)) {
            if (updater == null) {
                updater = this.makeSchemaVersionUpdateInstance(updateClassName);
                continue;
            }
            SchemaVersionUpdate nextUpdater = this.makeSchemaVersionUpdateInstance(updateClassName);
            updater.getLastUpdate().setNextUpdate(nextUpdater);
        }
        return updater == null ? new SchemaVersionNoUpdate() : updater;
    }

    String[] getSortedUpdaterClassnames(Map<String, String> updateMap, int fromVersion) throws HumanTaskServiceException {
        Set<String> updatePropertyNames = updateMap.keySet();
        ArrayList<UpdateRange> updateRanges = new ArrayList<UpdateRange>();
        for (String updatePropertyName : updatePropertyNames) {
            Range range = this.makeRange(updatePropertyName);
            if (range == null || range.getMinimumInteger() < fromVersion) continue;
            String className = updateMap.get(updatePropertyName);
            UpdateRange updateRange = new UpdateRange(range, className);
            updateRanges.add(updateRange);
        }
        Comparator<UpdateRange> rangeStartComparator = new Comparator<UpdateRange>(){

            @Override
            public int compare(UpdateRange one, UpdateRange two) {
                return Integer.valueOf(one.range.getMinimumInteger()).compareTo(two.range.getMinimumInteger());
            }
        };
        Collections.sort(updateRanges, rangeStartComparator);
        ArrayList<String> updateClasses = new ArrayList<String>();
        UpdateRange lastRange = null;
        for (UpdateRange updateRange : updateRanges) {
            int start = updateRange.range.getMinimumInteger();
            if (lastRange != null && start < lastRange.range.getMaximumInteger()) {
                throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_SCHEMA_LIST, new Exception(updateRange.updateClass));
            }
            lastRange = updateRange;
            updateClasses.add(updateRange.updateClass);
        }
        return updateClasses.toArray(new String[updateClasses.size()]);
    }

    private Range makeRange(String propertyName) {
        try {
            String[] versions = propertyName.split("_");
            int one = Integer.valueOf(versions[1]);
            int two = Integer.valueOf(versions[2]);
            return new IntRange(one, two);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private SchemaVersionUpdate makeSchemaVersionUpdateInstance(String className) throws HumanTaskServiceException {
        SchemaVersionUpdate updater = null;
        try {
            if (className != null && !"".equals(className)) {
                Class<?> clazz = Class.forName(className);
                updater = (SchemaVersionUpdate)clazz.newInstance();
                updater.setEntityManagerFactory(this.emf);
            } else {
                updater = new SchemaVersionNoUpdate();
            }
        }
        catch (Throwable t) {
            Utils.throwHumanTaskServiceException(t, UsI18NCode.MSG_US_SCHEMA_METADATA_GENERATION_FAILED, new Object[]{t.getLocalizedMessage()});
        }
        return updater;
    }

    @Override
    public SchemaVersionInstall getSchemaVersionInstall() throws HumanTaskServiceException {
        return new HTSRoboRepository(PersistenceUnit.ANNOTATIONS);
    }

    public String getUpdateVersionPropName(int fromVersion, int toVersion) {
        StringBuffer propName = new StringBuffer();
        propName.append(this.updatePrefix);
        propName.append("_");
        propName.append(fromVersion);
        propName.append("_");
        propName.append(toVersion);
        return propName.toString();
    }

    private class UpdateRange {
        public Range range;
        public String updateClass;

        public UpdateRange(Range range, String updateClass) {
            this.range = range;
            this.updateClass = updateClass;
        }
    }
}

