/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.schema;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.serverinst.InstanceUtil;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.version.repository.DBType;
import com.ibm.cognos.internal.annotations.dao.AnnotationDAO;
import com.ibm.cognos.internal.annotations.dao.impl.DAOFactory;
import com.ibm.cognos.internal.annotations.schema.AnnotationVersion;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.properties.HTSServerProperties;
import com.ibm.cognos.internal.hts.schema.HTSRoboRepository;
import com.ibm.cognos.internal.hts.schema.IVersionUpdate;
import com.ibm.cognos.internal.hts.schema.SchemaVersionChangeFactory;
import com.ibm.cognos.internal.hts.schema.SchemaVersionNoUpdate;
import com.ibm.cognos.internal.hts.schema.SchemaVersionUpdate;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.MappingTool;
import org.apache.openjpa.jdbc.schema.SchemaTool;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class SchemaUtil {
    private static final String SCHEMA_ACTION = "-schemaAction";
    private static final String ACTION = "-a";
    private static final String PERSISTENCE_UNIT_OPTION = "-p";
    private static final String PESISTENCE_UNIT_ROOT = "META-INF/hts_ans_openjpa.xml#";
    private static final String TEST_PESISTENCE_UNIT_ROOT = "META-INF/hts_ans_test_openjpa.xml#";
    private static final String BUILD_SCHEMAS_PROP = "humanTaskService_annotations.openJpaBuildSchemas";
    private IVersionUpdate versionTool;
    private JDBCConfigurationImpl config;
    private int current_version = 0;
    SchemaVersionChangeFactory updateFactory;

    public SchemaUtil(IVersionUpdate versionUpdater, SchemaVersionChangeFactory updateFactory, JDBCConfigurationImpl config) {
        this.versionTool = versionUpdater;
        this.updateFactory = updateFactory;
        this.config = config;
        try {
            this.current_version = versionUpdater.getDBVersionViaJdbc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean buildSchemas() {
        String updateDbProp = HTSServerProperties.getInstance().getProperty(BUILD_SCHEMAS_PROP);
        DBType dbType = new DBType("HTS", null);
        return Boolean.parseBoolean(updateDbProp) && !DatabaseType.DB2_ZOS.equals((Object)dbType.getType());
    }

    public boolean update(int version, PersistenceUnit persistenceUnit) throws HumanTaskServiceException {
        if (!this.buildSchemas()) {
            HTSRoboRepository robo = new HTSRoboRepository(persistenceUnit);
            robo.install(this.current_version);
            return true;
        }
        SchemaVersionUpdate versionUpdate = null;
        versionUpdate = this.updateFactory != null ? this.updateFactory.getSchemaVersionUpdate(this.current_version) : new SchemaVersionNoUpdate();
        try {
            if (this.current_version > 0) {
                versionUpdate.updatePreRefresh(this.current_version);
            }
        }
        catch (HumanTaskServiceException humanTaskServiceException) {
            // empty catch block
        }
        boolean dBVersionExists = this.runMappingTool(persistenceUnit, "validate", false);
        if (!dBVersionExists) {
            Object vendorObj;
            this.runMappingTool(persistenceUnit, "refresh", true);
            if (PersistenceUnit.ANNOTATIONS == persistenceUnit && (vendorObj = OpenJPAUtil.getConfigProperties().get("mssql.2008.and.up")) != null && vendorObj instanceof Boolean && ((Boolean)vendorObj).booleanValue()) {
                this.updateMSSQLdateTime();
            }
        }
        versionUpdate.updatePostRefresh();
        return this.versionTool.updateDBVersion(version);
    }

    private void updateMSSQLdateTime() {
        try {
            AnnotationDAO dao = new DAOFactory().buildDAO(AnnotationDAO.class);
            EntityManager em = OpenJPAUtil.getNamedEntityManagerFactory(PersistenceUnit.ANNOTATIONS).createEntityManager();
            OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
            Connection conn = (Connection)kem.getConnection();
            conn.setAutoCommit(false);
            dao.updateMSSQLdateTime(conn);
        }
        catch (Exception ex) {
            Utils.logException(ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug("SchemaUtil : There was a problem during MSSQL annotation dateTime update on dispatcher with id: " + InstanceUtil.getLocalDispatcherNodeIDGuid());
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_US_SCHEMA_UPDATE_FAILED, new Object[]{ex.getMessage()});
        }
    }

    public boolean runMappingTool(PersistenceUnit persistenceUnit, String actions, boolean barf) throws HumanTaskServiceException {
        boolean succeeded;
        block3: {
            succeeded = false;
            try {
                String persistenceUnitName = OpenJPAUtil.getPersistenceUnitName(persistenceUnit);
                String[] args = new String[]{ACTION, actions, PERSISTENCE_UNIT_OPTION, new String(PESISTENCE_UNIT_ROOT + persistenceUnitName)};
                succeeded = this.fireMappingTool(args);
            }
            catch (Throwable e) {
                if (!barf) break block3;
                Utils.logException(e);
            }
        }
        if (!succeeded && barf) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_SCHEMA_UPDATE_FAILED, new Object[0]);
        }
        return succeeded;
    }

    public void cleanTables() throws HumanTaskServiceException {
        this.fireMappingTool(new String[]{SCHEMA_ACTION, "deleteTableContents"});
    }

    public void dropTables(PersistenceUnit persistenceUnit) throws HumanTaskServiceException {
        this.fireMappingTool(new String[]{SCHEMA_ACTION, "refresh,drop", "-i"});
    }

    private boolean fireMappingTool(String[] options) throws HumanTaskServiceException {
        boolean succeeded = false;
        try {
            Options opts = new Options();
            String[] toolArgs = opts.setFromCmdLine(options);
            succeeded = MappingTool.run((JDBCConfiguration)this.config, (String[])toolArgs, (Options)opts);
        }
        catch (IOException ex) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_SCHEMA_UPDATE_FAILED, new Object[]{ex.getMessage()});
        }
        catch (SQLException ex) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_SCHEMA_UPDATE_FAILED, new Object[]{ex.getMessage()});
        }
        return succeeded;
    }

    public static void main(String[] args) {
        SchemaUtil.dropAllTables(PersistenceUnit.ANNOTATIONS);
        SchemaUtil.dumpc10(PersistenceUnit.ANNOTATIONS, "db21ANNcreate.sql");
    }

    private static void reflectSchema(PersistenceUnit pu, String file) {
        try {
            Options opts = new Options();
            String[] toolArgs = opts.setFromCmdLine(new String[]{PERSISTENCE_UNIT_OPTION, new String(PESISTENCE_UNIT_ROOT + pu.getName()), SCHEMA_ACTION, "reflect", "-file", "C:\\development\\cognos\\colorado_rp1\\src\\hts\\prod\\schema\\" + file});
            OpenJPAUtil.initialise();
            JDBCConfigurationImpl conf = OpenJPAUtil.createConfig();
            SchemaTool.run((JDBCConfiguration)conf, (String[])toolArgs, (Options)opts);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void dropAllTables(PersistenceUnit pu) {
        try {
            JDBCConnectionProperties.setInstanceInMemoryDb();
            OpenJPAUtil.initialise();
            OpenJPAUtil util = new OpenJPAUtil(pu);
            JDBCConfigurationImpl conf = null;
            AnnotationVersion version = new AnnotationVersion(OpenJPAUtil.getNamedEntityManagerFactory(pu), new DAOFactory());
            conf = OpenJPAUtil.createConfig();
            SchemaUtil sutil = new SchemaUtil(version, null, conf);
            sutil.fireMappingTool(new String[]{PERSISTENCE_UNIT_OPTION, new String(PESISTENCE_UNIT_ROOT + pu.getName()), SCHEMA_ACTION, "drop"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void dump(PersistenceUnit pu, String file) {
        try {
            JDBCConnectionProperties.setInstanceInMemoryDb();
            OpenJPAUtil.initialise();
            OpenJPAUtil util = new OpenJPAUtil(pu);
            JDBCConfigurationImpl conf = null;
            AnnotationVersion version = new AnnotationVersion(OpenJPAUtil.getNamedEntityManagerFactory(pu), new DAOFactory());
            conf = OpenJPAUtil.createConfig();
            SchemaUtil sutil = new SchemaUtil(version, null, conf);
            sutil.fireMappingTool(new String[]{PERSISTENCE_UNIT_OPTION, new String(PESISTENCE_UNIT_ROOT + pu.getName()), SCHEMA_ACTION, "refresh", "-sqlFile", "C:\\development\\cognos\\colorado_rp1\\src\\hts\\prod\\schema\\" + file});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void dumpc10(PersistenceUnit pu, String file) {
        try {
            JDBCConnectionProperties.setInstanceInMemoryDb();
            OpenJPAUtil.initialise();
            OpenJPAUtil util = new OpenJPAUtil(pu);
            JDBCConfigurationImpl conf = null;
            AnnotationVersion version = new AnnotationVersion(OpenJPAUtil.getNamedEntityManagerFactory(pu), new DAOFactory());
            conf = OpenJPAUtil.createConfig();
            SchemaUtil sutil = new SchemaUtil(version, null, conf);
            sutil.fireMappingTool(new String[]{PERSISTENCE_UNIT_OPTION, new String(TEST_PESISTENCE_UNIT_ROOT + pu.getName()), SCHEMA_ACTION, "refresh", "-sqlFile", "C:\\development\\cognos\\colorado_rp1\\src\\hts\\prod\\schema\\" + file});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

