/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.schema;

import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.VersionDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSVersion;
import com.ibm.cognos.internal.hts.schema.IVersionUpdate;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import java.sql.Connection;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class VersionUpdate
implements IVersionUpdate {
    @Override
    public int getDBVersionViaJdbc() throws Exception {
        int version = 0;
        VersionDAO dao = DAOFactory.getFactory().buildVersionDAO();
        EntityManager em = AbstractContext.getCurrentTransactionHandler().getEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        Connection conn = (Connection)kem.getConnection();
        conn.setAutoCommit(false);
        version = dao.getNativeVersion(conn);
        return version;
    }

    @Override
    public int getDBVersion() throws Exception {
        int version = 0;
        VersionDAO dao = DAOFactory.getFactory().buildVersionDAO();
        version = dao.findVersion().getDbVersionId();
        return version;
    }

    @Override
    public boolean updateDBVersion(int newVersion) {
        boolean updated;
        block4: {
            updated = true;
            HTSVersion version = null;
            try {
                VersionDAO dao = DAOFactory.getFactory().buildVersionDAO();
                version = dao.findVersion();
                if (version == null || version.getDbVersionId() < newVersion) {
                    AbstractContext.getCurrentTransactionHandler().beginTransaction();
                    this.addNewVersion(newVersion, dao);
                    AbstractContext.getCurrentTransactionHandler().commitTransaction();
                } else {
                    updated = false;
                }
            }
            catch (Throwable ex) {
                if (AbstractContext.getCurrentTransactionHandler() == null) break block4;
                AbstractContext.getCurrentTransactionHandler().rollbackTransaction();
            }
        }
        return updated;
    }

    private boolean updateExistingVersion(int newVersion, boolean updated, VersionDAO dao, HTSVersion hTSVersion) {
        if (hTSVersion != null && newVersion > hTSVersion.getDbVersionId()) {
            dao.update(hTSVersion);
            hTSVersion.setDbVersionId(newVersion);
        } else {
            updated = false;
        }
        return updated;
    }

    private void addNewVersion(int newVersion, VersionDAO dao) {
        HTSVersion hTSVersion = new HTSVersion();
        hTSVersion.setId(GuidUtils.create());
        hTSVersion.setDbVersionId(newVersion);
        dao.save(hTSVersion);
    }
}

