/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.service;

import com.cognos.jsmcommon.api.APIException;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.IBaseConfig;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.pogo.capacity.ServiceCapacity;
import com.cognos.pogo.capacity.ServiceCapacityConfiguration;
import com.cognos.pogo.capacity.ServiceCapacityMediator;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoIPFLog;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.deadlines.DeadLineScheduler;
import com.ibm.cognos.internal.hts.deadlines.DeadlineSchedulerImpl;
import com.ibm.cognos.internal.hts.logging.AuditLogService;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskSearchProperties;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.TaskSearchPropertiesOpenJPA;
import com.ibm.cognos.internal.hts.service.Registry;
import com.ibm.cognos.internal.hts.service.ServiceHandler;
import com.ibm.cognos.internal.hts.service.ServiceResponse;
import com.ibm.cognos.internal.hts.service.TaskMaintenanceService;
import com.ibm.cognos.internal.hts.service.TaskMaintenanceServiceImpl;
import com.ibm.cognos.internal.hts.util.BiBusHeaderUtilities;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidator;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidatorAtIntervals;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class BaseServiceHandler
extends BasicHandler {
    protected static final String RESPONSE_NAME = "response";
    protected static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(BaseServiceHandler.class.getName());
    protected boolean m_suspended = false;
    protected ServiceHandler m_handler;
    public static final String SOAP_ENVELOPE = "request.envelope";
    private boolean m_serviceFailedToInit = false;

    public BaseServiceHandler() {
        super(null);
    }

    public BaseServiceHandler(ServiceHandler handler) {
        super(null);
        this.m_handler = handler;
    }

    public void allServicesStarted() {
        if (this.m_serviceFailedToInit) {
            this.flagNotStartable();
            throw new RuntimeException("Human Task Service Failed to start");
        }
        Registry.getService(DeadLineScheduler.class).start();
        this.setSuspended(false);
    }

    public void start() {
        if (this.m_serviceFailedToInit) {
            this.flagNotStartable();
            throw new RuntimeException("Human Task Service Failed to start");
        }
        Registry.getService(TaskMaintenanceService.class).start();
        Registry.getService(AuditLogService.class).start();
        DBSchemaValidatorAtIntervals.getInstance().startDBSchemaValidationAtIntervals(DBSchemaValidator.ComponentName.HTS);
        this.setSuspended(false);
    }

    public void stop() {
        if (Registry.getService(DeadLineScheduler.class) != null) {
            Registry.getService(DeadLineScheduler.class).stop();
        }
        if (Registry.getService(TaskMaintenanceService.class) != null) {
            Registry.getService(TaskMaintenanceService.class).stop();
        }
        if (Registry.getService(AuditLogService.class) != null) {
            Registry.getService(AuditLogService.class).stop();
        }
        ServiceCapacityConfiguration config = new ServiceCapacityConfiguration("humanTaskService", "", 0);
        ServiceCapacityMediator.getInstance().notify((ServiceCapacity)config);
        this.setSuspended(true);
    }

    public void resume() {
        if (this.m_serviceFailedToInit) {
            throw new RuntimeException("Human Task Service could not be resumed");
        }
        ServiceCapacityConfiguration config = new ServiceCapacityConfiguration("humanTaskService", "", 4);
        ServiceCapacityMediator.getInstance().notify((ServiceCapacity)config);
        this.setSuspended(false);
    }

    public void suspend(boolean immediately) {
        if (this.m_serviceFailedToInit) {
            throw new RuntimeException("Human Task Service could not be suspended");
        }
        this.setSuspended(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.isSuspended()) {
            mc.setFault(new Fault("AbortIfSuspendedHandler.serviceStopped"));
            return;
        }
        try {
            BIBusEnvelope requestEnv = (BIBusEnvelope)mc.getProperty(SOAP_ENVELOPE);
            boolean kmtest = false;
            ThreadProperties.setProperty((String)"componentID", (String)"HTS");
            String requestOp = BiBusUtilities.getOperation((BIBusEnvelope)requestEnv);
            if (requestOp != null) {
                ThreadProperties.setProperty((String)"requestOperation", (String)requestOp);
            }
            ServiceResponse response = this.invokeRequest(requestEnv);
            this.buildResponse(mc, response);
        }
        catch (Throwable t) {
            this.setUnexpectedError(mc, t);
        }
        finally {
            ThreadProperties.clear();
        }
    }

    public void buildResponse(MessageContext mc, ServiceResponse response) throws Exception {
        if (response == null || response.getResponse() == null) {
            throw new Exception("Null response from service.");
        }
        BIBusEnvelope env = BiBusHeaderUtilities.getHeadedEnvelope(response.getHeader());
        Element bodyResponse = env.getBody();
        bodyResponse.add(response.getResponse());
        this.setEnvelope(mc, env);
    }

    protected void setEnvelope(MessageContext mc, BIBusEnvelope envelope) {
        this.outputBIBusEnvelope(envelope, I18NCode.MSG_SOAP_ENVELOPE_RESPONSE);
        this.fillMessageContext(mc, envelope);
    }

    private void fillMessageContext(MessageContext messageContext, BIBusEnvelope responseEnvelope) {
        Element bigFault = responseEnvelope.getBody().element("Fault");
        Element littleFault = responseEnvelope.getBody().element("fault");
        messageContext.setResponseName(RESPONSE_NAME);
        messageContext.setProperty("response.envelope", (Object)responseEnvelope);
        if (bigFault != null || littleFault != null) {
            messageContext.setProperty("responsestatus_code", (Object)"500");
            messageContext.setProperty("responsestatus_msg", (Object)"Internal Server error");
        } else {
            messageContext.setProperty("response.status_code", (Object)"200");
            messageContext.setProperty("response.status_msg", (Object)"OK");
        }
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Type", "text/xml");
        messageContext.setProperty("responseheaders", (Object)headers);
        messageContext.setProperty("responseboundary", null);
        messageContext.setProperty("responseattachments", null);
    }

    private void outputBIBusEnvelope(BIBusEnvelope envelope, I18NCode code) {
        if (SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT_REQUEST).isLoggingAt(SDSLevel.INFO)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                envelope.writeAsXML((OutputStream)baos);
                String requestString = baos.toString("UTF-8");
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT_REQUEST).log(SDSLevel.INFO, code, (Object[])new String[]{requestString});
            }
            catch (IOException ex) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug("Exception logging debug " + ex.getMessage());
            }
        }
    }

    public ServiceResponse invokeRequest(BIBusEnvelope requestEnv) throws Exception {
        return this.m_handler.execute(requestEnv);
    }

    public void configure(Configuration configuration) {
        CRNProperties config = CRNProperties.getInstance();
        config.init(configuration.getICCLConfiguration(), this.getName());
        CMProperties cmConfig = CMProperties.getInstance();
        cmConfig.init(configuration.getICCLConfiguration());
        ServiceCapacityConfiguration capacityConfig = new ServiceCapacityConfiguration("humanTaskService", "", 4);
        ServiceCapacityMediator.getInstance().notify((ServiceCapacity)capacityConfig);
    }

    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
        TaskMaintenanceService service = Registry.getService(TaskMaintenanceService.class);
        if (service != null) {
            service.stop();
            service.start();
        }
    }

    private void setSuspended(boolean suspended) {
        this.m_suspended = suspended;
    }

    private boolean isSuspended() {
        return this.m_suspended;
    }

    protected void setUnexpectedError(MessageContext mc, Throwable e) {
        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_ERROR_GENERATING_RESPONSE, (Object[])new String[]{"" + e.getMessage()});
        this.setFaultResponse(mc, new APIException((LocalizableException)new SDSServiceException(I18NCode.GEN_THROWABLE_ERROR, new Object[]{"" + e.getMessage()})));
    }

    private void setFaultResponse(MessageContext mc, APIException e) {
        BIBusEnvelope envelope = new BIBusEnvelope();
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty(SOAP_ENVELOPE);
        envelope.setTracking(request.getTracking().createCopy());
        envelope.createFaultElement(e.getFaultCode(Locale.getDefault()), e.getFaultString(Locale.getDefault()));
        Element detail = envelope.getFaultDetail();
        detail = e.getDom4JDetail(detail, Locale.getDefault());
        this.setEnvelope(mc, envelope);
    }

    ServiceHandler composeServiceHandler(List<String> serviceHandlers) throws PogoException {
        ServiceHandler handler = null;
        String serviceHandlerName = null;
        try {
            for (int i = serviceHandlers.size() - 1; i >= 0; --i) {
                serviceHandlerName = serviceHandlers.get(i);
                Class<?> handlerClass = Class.forName(serviceHandlerName);
                Constructor<?>[] constructors = handlerClass.getConstructors();
                Constructor<?> constructor = null;
                Object[] args = null;
                for (int j = 0; j < constructors.length; ++j) {
                    if (constructors[j].getParameterTypes().length != 1) continue;
                    constructor = constructors[j];
                    args = new Object[]{handler};
                }
                handler = (ServiceHandler)constructor.newInstance(args);
            }
        }
        catch (Throwable x) {
            logger.error("cannot instantiate wrapped handler class " + serviceHandlerName + ", substituted Noophandler", x);
            Object[] args = new Object[]{this.name, serviceHandlerName};
            String errorMsg = DispatcherStrings.getInstance().getString("HandlerFactory.cantInstantiate", args);
            PogoIPFLog.getInstance().logStartupError(errorMsg);
            throw new PogoException("cannot instantiate wrapped handler class");
        }
        return handler;
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        Iterator it;
        ArrayList<String> serviceHandlers = new ArrayList<String>();
        try {
            it = this.getConfig().selectNodes("serviceChain/service").iterator();
        }
        catch (Exception x) {
            logger.error("Jaxen/XPath problem", (Throwable)x);
            throw new PogoException("Handler config problem");
        }
        if (!it.hasNext()) {
            logger.warn("ChainHandler has no handlers!");
        }
        while (it.hasNext()) {
            Element e = (Element)it.next();
            String nameAttribute = e.attributeValue("name");
            if (nameAttribute == null || nameAttribute.length() == 0) {
                logger.error("no name attribute in service");
                throw new PogoException("service requires name attribute");
            }
            serviceHandlers.add(nameAttribute);
        }
        this.m_handler = this.composeServiceHandler(serviceHandlers);
        CRNProperties.serviceNames.setServiceName(CRNProperties.ServiceNames.ServiceKey.HUMAN, this.getName());
    }

    public void initialize() {
        try {
            super.initialize();
            this.m_handler.initialize();
            Registry.registerService(DeadLineScheduler.class, new DeadlineSchedulerImpl(DAOFactory.getFactory()));
            Registry.registerService(TaskSearchProperties.class, new TaskSearchPropertiesOpenJPA());
            Registry.registerService(TaskMaintenanceService.class, new TaskMaintenanceServiceImpl((IBaseConfig)CRNProperties.getInstance()));
            Registry.registerService(AuditLogService.class, new AuditLogService());
        }
        catch (Exception ex) {
            this.m_serviceFailedToInit = true;
            Utils.logException(ex);
            this.flagNotStartable();
        }
        finally {
            AbstractContext.setCurrentTransactionHandler(null);
        }
    }
}

