/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.service;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CachedWSDL
extends BasicHandler {
    private String gatewayLocation = null;
    private String schemaLocation = null;
    private static HashMap dataMap = new HashMap();
    private static final String sSDK_ENDPOINT = "@@SDK_ENDPOINT@@";
    private static final String sSCHEMA_ENDPOINT = "@@SCHEMA_ENDPOINT@@";
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(CachedWSDL.class.getName());
    private static final InternetHeaders responseHeaders = new InternetHeaders();
    private static final SOAPEnvelope dummyEnvelope = new BIBusEnvelope();
    private static final byte[] CONTENT_TYPE_HEADER = "Content-Type: text/xml; charset=utf-8\r\n\r\n".getBytes();

    public CachedWSDL(Logger arg) {
        super(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        byte[] content = null;
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        CachedWSDL cachedWSDL = this;
        synchronized (cachedWSDL) {
            try {
                String wsdl = (String)mc.getProperty("wsdl.name");
                String xsd = envelope.getFormValue("xsd");
                String resource = xsd != null ? xsd : wsdl;
                content = (byte[])dataMap.get(resource);
                if (content == null) {
                    content = this.getContent(resource);
                    String temp = new String(content, "UTF-8");
                    temp = this.replaceEndpoint(temp, sSDK_ENDPOINT, this.gatewayLocation);
                    temp = this.replaceEndpoint(temp, sSCHEMA_ENDPOINT, this.schemaLocation);
                    content = temp.getBytes("UTF-8");
                    dataMap.put(resource, content);
                }
            }
            catch (IOException ex) {
                mc.setFault(new Fault("CANNOT_READ_RESOURCE"));
                return;
            }
            if (content == null) {
                mc.setFault(new Fault("CANNOT_READ_RESOURCE"));
                return;
            }
        }
        ByteArrayInputStream wsdlStream = new ByteArrayInputStream(content);
        SequenceInputStream compositeStream = new SequenceInputStream(new ByteArrayInputStream(CONTENT_TYPE_HEADER), wsdlStream);
        ArrayList<SequenceInputStream> attachmentList = new ArrayList<SequenceInputStream>(1);
        attachmentList.add(compositeStream);
        mc.setProperty("response.status_code", (Object)"200");
        mc.setProperty("response.status_msg", (Object)"OK");
        mc.setProperty("response.headers", (Object)responseHeaders);
        mc.setProperty("response.envelope", (Object)dummyEnvelope);
        mc.setProperty("response.attachments", attachmentList.iterator());
        mc.setProperty("response.boundary", (Object)StringUtils.getUniqueValue());
    }

    public void configure(Configuration configuration) {
        this.gatewayLocation = configuration.getValue("internalDispatcher");
        this.schemaLocation = "../../schemas";
    }

    private String replaceEndpoint(String rawWSDL, String marker, String endpoint) {
        int currentMatch = rawWSDL.indexOf(marker);
        if (currentMatch == -1) {
            return rawWSDL;
        }
        int markerLength = marker.length();
        int currentStringPosition = 0;
        StringBuffer strBuf = new StringBuffer();
        while (currentMatch != -1) {
            strBuf.append(rawWSDL.substring(currentStringPosition, currentMatch));
            strBuf.append(endpoint);
            currentStringPosition = currentMatch + markerLength;
            currentMatch = rawWSDL.indexOf(marker, currentStringPosition);
        }
        int rawWSDLLength = rawWSDL.length();
        if (currentStringPosition < rawWSDLLength) {
            strBuf.append(rawWSDL.substring(currentStringPosition, rawWSDLLength));
        }
        return strBuf.toString();
    }

    private byte[] getContent(String wsdl) throws IOException {
        DataInputStream inStream = new DataInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(wsdl));
        if (inStream == null) {
            throw new IOException();
        }
        int bytesAvailable = inStream.available();
        byte[] data = new byte[bytesAvailable];
        inStream.readFully(data);
        return data;
    }
}

