/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.service;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.IBaseConfig;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.dao.Criteria;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.TaskMaintenanceLog;
import com.ibm.cognos.internal.hts.service.TaskMaintenanceService;
import com.ibm.cognos.internal.hts.service.TaskPurgeCheck;
import com.ibm.cognos.internal.hts.service.TaskPurgeContext;
import com.ibm.cognos.internal.hts.util.OMUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.TaskUtil;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.Duration;

public class TaskMaintenanceServiceImpl
implements TaskMaintenanceService {
    private ScheduledExecutorService _service;
    private long _repeat = 86400000L;
    private long _start = 0L;
    private boolean _enabled = true;
    private boolean _htsMaintenanceCmCheckEnabled = true;
    private boolean _htsMaintenanceManageAllTasksEnabled = false;
    private boolean _htsMaintenanceManageCompletedTasksEnabled = true;
    private static int DEFAULT_LIFETIME = 90;
    private ScheduledFuture<?> _reference = null;
    private IBaseConfig _properties = null;
    private int _htsNumberOfRecordsToFetchFromDB = 1000;
    private long _htsManageAllTasksDelay = 200L;
    private List<String> _htsMaintenanceDaysOfWeekToCarryOutMaintenance = null;
    private List<String> _strValidDaysOfWeek = new ArrayList<String>(Arrays.asList("sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"));

    public TaskMaintenanceServiceImpl(IBaseConfig properties) {
        this._properties = properties;
    }

    @Override
    public synchronized void start() {
        if (this._reference == null) {
            this.initialise();
            if (this._enabled) {
                if (this._service == null) {
                    this._service = Executors.newSingleThreadScheduledExecutor();
                }
                this._reference = this._service.scheduleAtFixedRate(this, this._start, this._repeat, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this._reference != null) {
            this._reference.cancel(true);
            this._service.shutdown();
            this._reference = null;
            this._service = null;
        }
    }

    @Override
    public void run() {
        this.manageTasks();
    }

    public void runOnce() {
        this.initialise();
        this.manageTasks();
    }

    public void manageTasks() {
        if (this.isTaskMaintenanceEnabled()) {
            if (this._htsMaintenanceManageAllTasksEnabled) {
                this.manageAllOldTasks();
            }
            if (this._htsMaintenanceManageCompletedTasksEnabled) {
                this.manageCompletedTasks();
            }
        }
    }

    public boolean isTaskMaintenanceEnabled() {
        boolean isTaskMaintenanceEnabled = true;
        try {
            isTaskMaintenanceEnabled = this.taskMaintenanceDayOfWeekCheck();
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : isTaskMaintenenceEnabled() : 1 : Error getting value for isTaskMaintenanceEnabled ");
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex);
        }
        return isTaskMaintenanceEnabled;
    }

    public boolean taskMaintenanceDayOfWeekCheck() {
        boolean canTaskMaintenanceBeCarriedOutToday = true;
        try {
            if (this._htsMaintenanceDaysOfWeekToCarryOutMaintenance != null && this._htsMaintenanceDaysOfWeekToCarryOutMaintenance.size() > 0) {
                Locale enUS = new Locale("en", "US");
                Calendar cal = Calendar.getInstance();
                String todayDOW = cal.getDisplayName(7, 2, enUS);
                if (todayDOW != null) {
                    todayDOW = todayDOW.trim();
                    if (!this._htsMaintenanceDaysOfWeekToCarryOutMaintenance.contains(todayDOW = todayDOW.toLowerCase())) {
                        canTaskMaintenanceBeCarriedOutToday = false;
                    }
                }
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : taskMaintenanceDayOfWeekCheck : 1 : Error during day of week check");
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex);
        }
        return canTaskMaintenanceBeCarriedOutToday;
    }

    public List<String> getHTSMaintenanceDaysOfWeekToCarryOutMaintenance() {
        String strHTSMaintenanceDsOW = "";
        ArrayList<String> htsMaintenanceDaysOfWeekToCarryOutMaintenance = null;
        try {
            String[] strDsOWTokens;
            htsMaintenanceDaysOfWeekToCarryOutMaintenance = new ArrayList<String>();
            strHTSMaintenanceDsOW = this.getHTSMaintenanceDaysOfWeek();
            if (strHTSMaintenanceDsOW != null && strHTSMaintenanceDsOW.length() > 0 && (strDsOWTokens = strHTSMaintenanceDsOW.split(",")) != null && strDsOWTokens.length > 0) {
                for (String strDayOfWeek : strDsOWTokens) {
                    if (strDayOfWeek == null) continue;
                    strDayOfWeek = strDayOfWeek.trim();
                    if (!this._strValidDaysOfWeek.contains(strDayOfWeek = strDayOfWeek.toLowerCase())) continue;
                    htsMaintenanceDaysOfWeekToCarryOutMaintenance.add(strDayOfWeek);
                }
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : getHTSMaintenanceDaysOfWeekToCarryOutMaintenance : 1 : Error getting days of week");
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex);
        }
        return htsMaintenanceDaysOfWeekToCarryOutMaintenance;
    }

    public String getHTSMaintenanceDaysOfWeek() {
        String strHTSMaintenanceDaysOfWeek = "";
        try {
            strHTSMaintenanceDaysOfWeek = this._properties.getProperty("hts.maintenance.days.of.week");
            strHTSMaintenanceDaysOfWeek = strHTSMaintenanceDaysOfWeek != null ? strHTSMaintenanceDaysOfWeek.trim() : "";
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [hts.maintenance.days.of.week]: " + e.getMessage());
        }
        catch (Exception ex) {
            Utils.debug("Invalid property set for [hts.maintenance.days.of.week]: " + ex.getMessage());
        }
        return strHTSMaintenanceDaysOfWeek;
    }

    private void manageCompletedTasks() {
        this.manageTasks("Task.CompletedOn");
    }

    private void manageAllOldTasks() {
        this.manageTasks("Task.CreateDate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageTasks(String taskCriteria) {
        ZipiTimer zipiTimer = null;
        try {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : manageTasks : 1 : ");
            zipiTimer = ZipiBridge.startTimer((String)"HTS: TaskMaintenanceService : manageTasks");
            OpenJPAUtil trx = null;
            List<HTSTask> tasks = null;
            boolean loopAgain = false;
            if (taskCriteria == null) {
                return;
            }
            do {
                block23: {
                    try {
                        trx = new OpenJPAUtil(PersistenceUnit.HUMANTASK_SERVICE);
                        trx.openSession();
                        AbstractContext.setCurrentTransactionHandler(trx);
                        trx.beginTransaction();
                        if (taskCriteria.equals("Task.CreateDate")) {
                            tasks = this.getTasksByCreationDate(this._htsNumberOfRecordsToFetchFromDB);
                        } else if (taskCriteria.equals("Task.CompletedOn")) {
                            tasks = this.getTasksByCompletionDate(this._htsNumberOfRecordsToFetchFromDB);
                        }
                        if (tasks != null && tasks.size() > 0) {
                            this.deleteTasks(tasks, this._htsMaintenanceCmCheckEnabled);
                            loopAgain = true;
                        } else {
                            loopAgain = false;
                        }
                        if (trx != null) {
                            try {
                                trx.commitTransaction();
                                trx.closeSession();
                                AbstractContext.setCurrentTransactionHandler(null);
                            }
                            catch (Exception ex1) {
                                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : manageTasks : 2 : Error attempting to commit transaction and close session");
                                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex1);
                            }
                        }
                    }
                    catch (Exception ex) {
                        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : manageTasks : 3 : Error : " + ex);
                        loopAgain = false;
                        if (trx == null) break block23;
                        try {
                            trx.rollbackTransaction();
                            trx.closeSession();
                            AbstractContext.setCurrentTransactionHandler(null);
                        }
                        catch (Exception ex1) {
                            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : manageTasks : 4 : Error attempting to commit transaction and close session");
                            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex1);
                        }
                    }
                }
                if (this._htsManageAllTasksDelay <= 0L || !loopAgain) continue;
                try {
                    Thread.sleep(this._htsManageAllTasksDelay);
                }
                catch (InterruptedException iex) {
                    loopAgain = false;
                    break;
                }
            } while (loopAgain);
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : manageAllOldTasks : 5 : Error: " + ex);
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTasks(List<HTSTask> tasks, boolean checkForCMLinks) {
        TaskMaintenanceLog tmlog = null;
        String strTaskId = "";
        ZipiTimer zipiTimer = null;
        try {
            zipiTimer = ZipiBridge.startTimer((String)"HTS: TaskMaintenanceService : deleteTasks");
            if (tasks != null && tasks.size() > 0) {
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : deleteTasks : 1 : Attempting to delete: " + tasks.size() + " : tasks. ");
                TaskDAO dao = DAOFactory.getFactory().buildTaskDAO();
                BiBusHeader header = OMUtils.createEmptyBiBusHeader();
                JobBiBusHeaders headers = new JobBiBusHeaders(header);
                tmlog = new TaskMaintenanceLog();
                boolean canPurgeTask = true;
                ArrayList<HTSTask> deletedChildren = new ArrayList<HTSTask>();
                for (HTSTask task : tasks) {
                    try {
                        strTaskId = task.getId();
                        canPurgeTask = true;
                        tmlog.addToBeDeletedTask(strTaskId);
                        if (checkForCMLinks) {
                            TaskPurgeContext context = new TaskPurgeContext();
                            context.setHTSTask(task);
                            context.setHeaders(headers);
                            TaskPurgeCheck purge = new TaskPurgeCheck();
                            canPurgeTask = purge.canPurge(context);
                        }
                        if (canPurgeTask) {
                            tmlog.addCanBeDeletedTask(strTaskId);
                            if (!deletedChildren.contains(task)) {
                                deletedChildren.addAll(TaskUtil.deleteAllChildTasks(task));
                                dao.delete(task);
                            }
                            tmlog.addDeletedTask(strTaskId);
                            continue;
                        }
                        tmlog.addCannotBeDeletedTask(strTaskId);
                    }
                    catch (Exception e) {
                        tmlog.addErrorDeletingTask(strTaskId);
                        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : deleteTasks : 2 : Error attempting to purge a task");
                        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)e);
                    }
                    finally {
                        strTaskId = "";
                    }
                }
                tmlog.addDeletedTask(deletedChildren);
            } else {
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : deleteTasks : 3 : Task list is null (empty), cannot delete tasks.");
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : deleteTasks : 4 : Error deleting tasks.");
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex);
        }
        finally {
            try {
                if (tmlog != null) {
                    tmlog.log();
                }
            }
            catch (Exception ex1) {
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : deleteTasks : 5 : Error attempting to commit transaction and close session");
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex1);
            }
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    private void initialise() {
        this.initialiseProperties();
        try {
            String boolVal = this._properties.getProperty("hts.maintenance.enabled");
            if (boolVal != null && boolVal.length() > 0) {
                this._enabled = Boolean.valueOf(boolVal);
            }
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [hts.maintenance.enabled]: " + e.getMessage());
        }
        try {
            String hourVal = this._properties.getProperty("hts.maintenance.hour");
            if (hourVal != null && hourVal.length() > 0) {
                Integer hourOfDay = Integer.valueOf(hourVal);
                if (hourOfDay >= 0 && hourOfDay < 24) {
                    Calendar cal = Calendar.getInstance();
                    int currentHour = cal.get(11);
                    cal.set(11, hourOfDay);
                    if (hourOfDay <= currentHour) {
                        cal.add(5, 1);
                    }
                    this.setDelay(cal);
                } else {
                    Utils.debug("Invalid property set for [hts.maintenance.hour]. Value must be between 0 and 23 inclusive.");
                }
            }
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [hts.maintenance.hour]: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            Utils.debug("Invalid property set for [hts.maintenance.hour]: " + e.getMessage());
        }
        try {
            String intVal = this._properties.getProperty("hts.maintenance.interval");
            if (intVal != null && intVal.length() > 0) {
                Integer hours = Integer.valueOf(intVal);
                if (hours > 0) {
                    this._repeat = (long)hours.intValue() * 3600000L;
                } else {
                    Utils.debug("Invalid property set for [hts.maintenance.interval]. Value must be greater than 0.");
                }
            }
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [hts.maintenance.interval]: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            Utils.debug("Invalid property set for [hts.maintenance.interval]: " + e.getMessage());
        }
    }

    private void initialiseProperties() {
        String boolVal;
        this._htsMaintenanceDaysOfWeekToCarryOutMaintenance = this.getHTSMaintenanceDaysOfWeekToCarryOutMaintenance();
        try {
            String intVal = this._properties.getProperty("htsNumberOfRecordsToFetchFromDB");
            if (intVal != null && intVal.length() > 0) {
                Integer numRecsToFetch = Integer.valueOf(intVal);
                if (numRecsToFetch != null && numRecsToFetch > 0) {
                    this._htsNumberOfRecordsToFetchFromDB = numRecsToFetch;
                } else {
                    Utils.debug("Invalid property set for [htsNumberOfRecordsToFetchFromDB]. Value must be greater than 0.");
                }
            }
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [htsNumberOfRecordsToFetchFromDB]: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            Utils.debug("Invalid property set for [htsNumberOfRecordsToFetchFromDB]: " + e.getMessage());
        }
        catch (Exception ex) {
            Utils.debug("Invalid property set for [htsNumberOfRecordsToFetchFromDB]: " + ex.getMessage());
        }
        try {
            boolVal = this._properties.getProperty("hts.maintenance.cm.check.enabled");
            if (boolVal != null && boolVal.length() > 0) {
                this._htsMaintenanceCmCheckEnabled = Boolean.valueOf(boolVal);
            }
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [hts.maintenance.cm.check.enabled]: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            Utils.debug("Invalid property set for [hts.maintenance.cm.check.enabled]: " + e.getMessage());
        }
        catch (Exception ex) {
            Utils.debug("Invalid property set for [hts.maintenance.cm.check.enabled]: " + ex.getMessage());
        }
        try {
            boolVal = this._properties.getProperty("hts.maintenance.manage.all.tasks.enabled");
            if (boolVal != null && boolVal.length() > 0) {
                this._htsMaintenanceManageAllTasksEnabled = Boolean.valueOf(boolVal);
            }
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [hts.maintenance.manage.all.tasks.enabled]: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            Utils.debug("Invalid property set for [hts.maintenance.manage.all.tasks.enabled]: " + e.getMessage());
        }
        catch (Exception ex) {
            Utils.debug("Invalid property set for [hts.maintenance.manage.all.tasks.enabled]: " + ex.getMessage());
        }
        try {
            boolVal = this._properties.getProperty("hts.maintenance.manage.completed.tasks.enabled");
            if (boolVal != null && boolVal.length() > 0) {
                this._htsMaintenanceManageCompletedTasksEnabled = Boolean.valueOf(boolVal);
            }
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [hts.maintenance.manage.completed.tasks.enabled]: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            Utils.debug("Invalid property set for [hts.maintenance.manage.completed.tasks.enabled]: " + e.getMessage());
        }
        catch (Exception ex) {
            Utils.debug("Invalid property set for [hts.maintenance.manage.completed.tasks.enabled]: " + ex.getMessage());
        }
        try {
            String longVal = this._properties.getProperty("hts.maintenance.manage.all.tasks.delay");
            if (longVal != null && longVal.length() > 0) {
                Long manageAllTasksDelay = Long.valueOf(longVal);
                if (manageAllTasksDelay != null && manageAllTasksDelay > 0L) {
                    this._htsManageAllTasksDelay = manageAllTasksDelay;
                } else {
                    Utils.debug("Invalid property set for [hts.maintenance.manage.all.tasks.delay]. Value must be greater than 0.");
                }
            }
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [hts.maintenance.manage.all.tasks.delay]: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            Utils.debug("Invalid property set for [hts.maintenance.manage.all.tasks.delay]: " + e.getMessage());
        }
        catch (Exception ex) {
            Utils.debug("Invalid property set for [hts.maintenance.manage.all.tasks.delay]: " + ex.getMessage());
        }
    }

    protected Date getLifetime(String crnPropertyName) {
        Calendar cal = this.currentTime();
        cal.add(5, -DEFAULT_LIFETIME);
        Date lifetime = cal.getTime();
        try {
            String lifeDuration;
            if (crnPropertyName != null && crnPropertyName.length() > 0 && (lifeDuration = this._properties.getProperty(crnPropertyName)) != null && lifeDuration.length() > 0) {
                Duration duration = Utils.getDataTypeFactory().newDuration(lifeDuration);
                Calendar durationCal = this.currentTime();
                duration.negate().addTo(durationCal);
                lifetime = durationCal.getTime();
            }
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [htsCompletedTaskLifetime]: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            Utils.debug("Invalid property set for [htsCompletedTaskLifetime]: " + e.getMessage());
        }
        catch (HumanTaskServiceException e) {
            Utils.debug("Invalid property set for [htsCompletedTaskLifetime]: " + e.getMessage());
        }
        return lifetime;
    }

    protected Date getTaskLifetimeByCompletionDate() {
        return this.getLifetime("htsCompletedTaskLifetime");
    }

    protected Date getTaskLifetimeByCreationDate() {
        return this.getLifetime("htsCreatedTaskLifetime");
    }

    protected void setDelay(Calendar cal) {
        cal.clear(12);
        cal.clear(14);
        long requestedHour = cal.getTime().getTime();
        this._start = requestedHour - this.currentTime().getTimeInMillis();
    }

    protected List<HTSTask> getTasksByCompletionDate(int maxNumberOfTasksToGet) {
        List<HTSTask> tasks = null;
        try {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : getTasksByCompletionDate : 1 : trying to get tasks by completion date");
            TaskDAO dao = DAOFactory.getFactory().buildTaskDAO();
            Criteria criteria = dao.buildCriteria();
            criteria.getWhereClause().addWhereClause("Task.CompletedOn", "<", this.getTaskLifetimeByCompletionDate().getTime());
            if (maxNumberOfTasksToGet != 0) {
                criteria.setMaxReturnCount(maxNumberOfTasksToGet);
            }
            tasks = dao.findByCriteria(criteria);
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : getTasksByCompletionDate : 2 : number of tasks found: " + (tasks != null ? "" + tasks.size() : "no tasks found, tasks list is null"));
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : getTasksByCompletionDate : 3 : Error deleting tasks.");
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex);
        }
        return tasks;
    }

    protected List<HTSTask> getTasksByCreationDate(int maxNumberOfTasksToGet) {
        List<HTSTask> tasks = null;
        try {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : getTasksByCreationDate : 1 : trying to get tasks by creation date");
            TaskDAO dao = DAOFactory.getFactory().buildTaskDAO();
            Criteria criteria = dao.buildCriteria();
            criteria.getWhereClause().addWhereClause("Task.CreateDate", "<", this.getTaskLifetimeByCreationDate().getTime());
            if (maxNumberOfTasksToGet != 0) {
                criteria.setMaxReturnCount(maxNumberOfTasksToGet);
            }
            tasks = dao.findByCriteria(criteria);
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : getTasksByCreationDate : 2 : number of tasks found: " + (tasks != null ? "" + tasks.size() : "no tasks found, tasks list is null"));
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("TaskMaintenanceService : getTasksByCreationDate : 3 : Error deleting tasks.");
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)ex);
        }
        return tasks;
    }

    protected Calendar currentTime() {
        return Calendar.getInstance();
    }

    void setExecutorService(ScheduledExecutorService service) {
        this._service = service;
    }
}

